/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.aura;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;
import thaumcraft.common.world.aura.AuraThread;
import thaumcraft.common.world.aura.AuraWorld;
import thecodex6824.thaumcraftfix.api.aura.IAuraChunk;
import thecodex6824.thaumcraftfix.common.aura.AtomicAuraChunk;
import thecodex6824.thaumcraftfix.common.aura.GenericAuraWorld;

@Mixin(value={AuraHandler.class})
public class AuraHandlerMixin {
    @Redirect(method={"addAuraWorld(I)V"}, at=@At(value="NEW", target="(I)Lthaumcraft/common/world/aura/AuraWorld;"), remap=false)
    private static AuraWorld redirectAddWorld(int dim) {
        return new GenericAuraWorld(dim);
    }

    @Redirect(method={"addAuraChunk(ILnet/minecraft/world/chunk/Chunk;SFF)V"}, at=@At(value="NEW", target="(I)Lthaumcraft/common/world/aura/AuraWorld;"), remap=false)
    private static AuraWorld redirectAddWorldInAddAuraChunk(int dim) {
        return new GenericAuraWorld(dim);
    }

    @Redirect(method={"addAuraChunk(ILnet/minecraft/world/chunk/Chunk;SFF)V"}, at=@At(value="NEW", target="(Lnet/minecraft/world/chunk/Chunk;SFF)Lthaumcraft/common/world/aura/AuraChunk;"), remap=false)
    private static AuraChunk redirectAddAuraChunk(Chunk chunk, short base, float vis, float flux) {
        return new AtomicAuraChunk(chunk, base, vis, flux);
    }

    @Inject(method={"removeAuraWorld(I)V"}, at={@At(value="RETURN")}, remap=false)
    private static void removeAuraWorldStopThread(int dim, CallbackInfo info) {
        AuraThread thread = (AuraThread)ServerEvents.auraThreads.get(dim);
        if (thread != null) {
            thread.stop();
        }
    }

    @Overwrite(remap=false)
    public static float drainVis(World world, BlockPos pos, float amount, boolean simulate) {
        AuraChunk ac = AuraHandler.getAuraChunk((int)world.field_73011_w.getDimension(), (int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        if (ac != null) {
            if (simulate) {
                float ret = amount;
                float test = ac.getVis() - amount;
                if (test >= 32767.0f) {
                    ret = 32767.0f - ac.getVis();
                } else if (test < 0.0f) {
                    ret = ac.getVis();
                }
                return ret;
            }
            if (ac instanceof IAuraChunk) {
                return -((IAuraChunk)ac).addVis(-amount);
            }
        }
        return 0.0f;
    }

    @Overwrite(remap=false)
    public static float drainFlux(World world, BlockPos pos, float amount, boolean simulate) {
        AuraChunk ac = AuraHandler.getAuraChunk((int)world.field_73011_w.getDimension(), (int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        if (ac != null) {
            if (simulate) {
                float ret = amount;
                float test = ac.getFlux() - amount;
                if (test >= 32767.0f) {
                    ret = 32767.0f - ac.getFlux();
                } else if (test < 0.0f) {
                    ret = ac.getFlux();
                }
                return ret;
            }
            if (ac instanceof IAuraChunk) {
                return -((IAuraChunk)ac).addFlux(-amount);
            }
        }
        return 0.0f;
    }

    @Overwrite(remap=false)
    public static boolean modifyVisInChunk(AuraChunk ac, float amount, boolean notSimulate) {
        if (notSimulate && ac instanceof IAuraChunk) {
            ((IAuraChunk)ac).addVis(amount);
            return true;
        }
        return false;
    }

    @Overwrite(remap=false)
    private static boolean modifyFluxInChunk(AuraChunk ac, float amount, boolean notSimulate) {
        if (notSimulate && ac instanceof IAuraChunk) {
            ((IAuraChunk)ac).addFlux(amount);
            return true;
        }
        return false;
    }
}

