/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thecodex6824.thaumcraftfix.api.research.ResearchCategoryTheorycraftFilter;

public class TheorycraftTransformersHooks {
    public static boolean isTheorycraftCategoryAllowed(boolean originalDecision, String category, EntityPlayer player, ResearchTableData data) {
        return originalDecision && data.getAvailableCategories(player).contains(category) && ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories().stream().map(c -> c.key).anyMatch(s -> s.equals(category));
    }

    public static ArrayList<String> filterTheorycraftCategories(ArrayList<String> input) {
        input.retainAll(ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories().stream().map(c -> c.key).collect(Collectors.toList()));
        return input;
    }

    public static ArrayList<String> filterTheorycraftCategories(ArrayList<String> input, EntityPlayer player, ResearchTableData data) {
        input.retainAll(data.getAvailableCategories(player));
        input.retainAll(ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories().stream().map(c -> c.key).collect(Collectors.toList()));
        return input;
    }

    public static String[] filterTheorycraftCategoriesArray(String[] input, EntityPlayer player, ResearchTableData data) {
        ArrayList<String> list = Lists.newArrayList((Object[])input);
        list = TheorycraftTransformersHooks.filterTheorycraftCategories(list, player, data);
        return list.toArray(new String[0]);
    }
}

