/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.items.IScribeTools;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.event.research.ResearchEntryLoadEvent;
import thecodex6824.thaumcraftfix.api.event.research.ResearchLoadEvent;
import thecodex6824.thaumcraftfix.common.network.PacketGainKnowledge;
import thecodex6824.thaumcraftfix.common.network.PacketGainResearch;

public class ResearchTransformersHooks {
    public static void sendKnowledgeGainPacket(EntityPlayer player, IPlayerKnowledge.EnumKnowledgeType type, ResearchCategory category, int amount) {
        if (player instanceof EntityPlayerMP) {
            ThaumcraftFix.instance.getNetworkHandler().sendTo((IMessage)new PacketGainKnowledge(type, category, amount), (EntityPlayerMP)player);
        }
    }

    public static void sendResearchGainPacket(EntityPlayer player, String researchKey) {
        if (player instanceof EntityPlayerMP) {
            ThaumcraftFix.instance.getNetworkHandler().sendTo((IMessage)new PacketGainResearch(researchKey), (EntityPlayerMP)player);
        }
    }

    public static String[] fixupFirstPassSplit(String rawText, String separator, String[] split) {
        if (rawText.endsWith(separator)) {
            split = Arrays.copyOf(split, split.length + 1);
            split[split.length - 1] = "";
        }
        return split;
    }

    public static void researchLoadStart() {
        MinecraftForge.EVENT_BUS.post((Event)new ResearchLoadEvent.Pre());
    }

    public static void researchLoadEnd() {
        MinecraftForge.EVENT_BUS.post((Event)new ResearchLoadEvent.Post());
    }

    public static boolean entryLoadStart(JsonObject json) {
        ResearchEntryLoadEvent.Pre event = new ResearchEntryLoadEvent.Pre(json);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static void entryLoadEnd(JsonObject json, ResearchEntry entry) {
        MinecraftForge.EVENT_BUS.post((Event)new ResearchEntryLoadEvent.Post(json, entry));
    }

    public static InputStream getFilesystemStream(InputStream stream, ResourceLocation loc) {
        String prefix = "$filesystem:";
        if (stream == null && loc.func_110624_b().equals("thaumcraftfix") && loc.func_110623_a().startsWith(prefix)) {
            Path gameDir = ThaumcraftFix.proxy.getGameDirectory().toPath().normalize();
            Path requested = Paths.get(loc.func_110623_a().substring(prefix.length()), new String[0]);
            if (!requested.isAbsolute() && requested.getRoot() == null) {
                try {
                    stream = new FileInputStream(gameDir.resolve(requested.normalize()).toFile());
                }
                catch (IOException ex) {
                    ThaumcraftFix.instance.getLogger().error("Failed opening research file: ", (Throwable)ex);
                }
            } else {
                ThaumcraftFix.instance.getLogger().error("Illegal research entry path, paths must be relative to the game directory: " + requested);
            }
        }
        return stream;
    }

    public static boolean isPlayerCarryingScribingTools(ItemStack isCarrying, boolean ore, boolean original, EntityPlayer player) {
        if (original || isCarrying.func_77973_b() != ItemsTC.scribingTools) {
            return original;
        }
        for (ItemStack stack : Iterables.concat((Iterable)player.field_71071_by.field_184439_c, (Iterable)player.field_71071_by.field_70462_a)) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IScribeTools)) continue;
            return true;
        }
        return false;
    }
}

