/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.common.container.ContainerFocalManipulator;
import thaumcraft.common.container.ContainerThaumatorium;
import thaumcraft.common.lib.network.misc.PacketLogisticsRequestToServer;
import thaumcraft.common.lib.network.misc.PacketNote;
import thaumcraft.common.lib.network.misc.PacketSelectThaumotoriumRecipeToServer;
import thaumcraft.common.lib.network.playerdata.PacketFocusNodesToServer;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;
import thaumcraft.common.tiles.crafting.TileResearchTable;
import thecodex6824.thaumcraftfix.ThaumcraftFix;

public class NetworkTransformersHooks {
    private static Field logisticsRequestPosition;
    private static volatile Method originalPacketNoteHandle;
    private static Field packetNoteDim;
    private static Field packetNoteX;
    private static Field packetNoteY;
    private static Field packetNoteZ;
    private static Field thaumatoriumRecipePosition;
    private static Field containerThaumatoriumTile;
    private static Field focusNodesPosition;
    private static Field containerFocalManipulatorTile;

    private static boolean validatePosition(EntityPlayerMP player, BlockPos target, String component) {
        if (!player.func_130014_f_().func_175667_e(target)) {
            ThaumcraftFix.instance.getLogger().warn("Player {} ({}) sent {} for unloaded position {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)component, (Object)target.toString());
            return false;
        }
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d end = new Vec3d((Vec3i)target).func_72441_c(0.5, 0.5, 0.5);
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 1.0;
        double distance = start.func_72436_e(end);
        if (distance > reach * reach) {
            ThaumcraftFix.instance.getLogger().warn("Player {} ({}) sent {} for a position too far away. Pos = {}, distance = {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)component, (Object)target.toString(), (Object)Math.sqrt(distance));
            return false;
        }
        return true;
    }

    public static boolean validateLogisticsRequest(PacketLogisticsRequestToServer message, MessageContext ctx) throws Exception {
        if (logisticsRequestPosition == null) {
            logisticsRequestPosition = PacketLogisticsRequestToServer.class.getDeclaredField("pos");
            logisticsRequestPosition.setAccessible(true);
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        boolean ok = player.func_70089_S();
        BlockPos pos = (BlockPos)logisticsRequestPosition.get(message);
        if (ok && pos != null) {
            ok = NetworkTransformersHooks.validatePosition(player, pos, "logistics request");
        }
        return ok;
    }

    public static void handlePacketNote(PacketNote message, MessageContext ctx) throws Exception {
        if (originalPacketNoteHandle == null) {
            originalPacketNoteHandle = PacketNote.class.getMethod("onMessageOriginalRedirectedByTCFix", PacketNote.class, MessageContext.class);
        }
        ThaumcraftFix.proxy.scheduleTask(ctx.side, () -> {
            try {
                boolean ok = true;
                if (ctx.side == Side.SERVER) {
                    int dim;
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    if (packetNoteDim == null) {
                        packetNoteDim = PacketNote.class.getDeclaredField("dim");
                        packetNoteDim.setAccessible(true);
                    }
                    if ((dim = packetNoteDim.getInt(message)) != player.field_71093_bK) {
                        ok = false;
                        ThaumcraftFix.instance.getLogger().warn("Player {} ({}) tried to get note status of a dimension they weren't in. Player dim = {}, requested dim = {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)player.field_71093_bK, (Object)dim);
                    }
                    if (ok) {
                        if (packetNoteX == null) {
                            packetNoteX = PacketNote.class.getDeclaredField("x");
                            packetNoteX.setAccessible(true);
                            packetNoteY = PacketNote.class.getDeclaredField("y");
                            packetNoteY.setAccessible(true);
                            packetNoteZ = PacketNote.class.getDeclaredField("z");
                            packetNoteZ.setAccessible(true);
                        }
                        BlockPos pos = new BlockPos(packetNoteX.getInt(message), packetNoteY.getInt(message), packetNoteZ.getInt(message));
                        ok = NetworkTransformersHooks.validatePosition(player, pos, "note status");
                    }
                }
                if (ok) {
                    originalPacketNoteHandle.invoke((Object)message, message, ctx);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public static boolean validateThaumatoriumSelection(PacketSelectThaumotoriumRecipeToServer message, MessageContext ctx) throws Exception {
        if (thaumatoriumRecipePosition == null) {
            thaumatoriumRecipePosition = PacketSelectThaumotoriumRecipeToServer.class.getDeclaredField("pos");
            thaumatoriumRecipePosition.setAccessible(true);
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        boolean ok = player.func_70089_S();
        BlockPos pos = BlockPos.func_177969_a((long)thaumatoriumRecipePosition.getLong(message));
        if (ok && pos != null && (ok = NetworkTransformersHooks.validatePosition(player, pos, "thaumatorium recipe selection"))) {
            if (containerThaumatoriumTile == null) {
                containerThaumatoriumTile = ContainerThaumatorium.class.getDeclaredField("thaumatorium");
                containerThaumatoriumTile.setAccessible(true);
            }
            ok = player.field_71070_bA instanceof ContainerThaumatorium && ((TileEntity)containerThaumatoriumTile.get(player.field_71070_bA)).func_174877_v().equals((Object)pos);
        }
        return ok;
    }

    public static boolean validateFocalManipulatorNodeData(PacketFocusNodesToServer message, MessageContext ctx) throws Exception {
        if (focusNodesPosition == null) {
            focusNodesPosition = PacketFocusNodesToServer.class.getDeclaredField("loc");
            focusNodesPosition.setAccessible(true);
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        boolean ok = player.func_70089_S();
        BlockPos pos = BlockPos.func_177969_a((long)focusNodesPosition.getLong(message));
        if (ok && pos != null) {
            boolean bl = ok = NetworkTransformersHooks.validatePosition(player, pos, "focal manipulator node selections") && player.field_71070_bA instanceof ContainerFocalManipulator;
            if (ok) {
                TileFocalManipulator tile;
                if (containerFocalManipulatorTile == null) {
                    containerFocalManipulatorTile = ContainerFocalManipulator.class.getDeclaredField("table");
                    containerFocalManipulatorTile.setAccessible(true);
                }
                ok = (tile = (TileFocalManipulator)containerFocalManipulatorTile.get(player.field_71070_bA)).func_174877_v().equals((Object)pos) && tile.vis <= 0.0f;
            }
        }
        return ok;
    }

    public static Set<String> filterResearchAids(Set<String> toFilter, EntityPlayer player, TileEntity table) {
        HashSet<String> ret = new HashSet<String>(toFilter);
        ret.retainAll(((TileResearchTable)table).checkSurroundingAids());
        return ret;
    }
}

