/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.lib.crafting.ContainerFake;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.common.inventory.FakeArcaneWorkbenchInventory;
import thecodex6824.thaumcraftfix.common.inventory.InventoryCraftingWrapper;

public class MiscTransformersHooks {
    private static final Set<ResourceLocation> BROKEN_RECIPES = new HashSet<ResourceLocation>();

    public static boolean handleEmptyAspectList(ItemStack stack, AspectList list) {
        if (list == null || list.size() == 0) {
            try {
                if (stack.func_77984_f() || !stack.func_77981_g()) {
                    stack = stack.func_77946_l();
                    stack.func_77964_b(Short.MAX_VALUE);
                }
                CommonInternals.objectTags.putIfAbsent(CommonInternals.generateUniqueItemstackId((ItemStack)stack), new AspectList());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static InventoryCrafting makeVanillaRecipeWrapper(InventoryCrafting input) {
        return new InventoryCraftingWrapper(input);
    }

    @Nullable
    public static InventoryCrafting createFilledInventoryForRecipe(IRecipe recipe) {
        boolean matches;
        FakeArcaneWorkbenchInventory ret;
        block12: {
            if (recipe.func_192399_d() || !recipe.func_194133_a(3, 3)) {
                return null;
            }
            ret = null;
            ret = recipe instanceof IArcaneRecipe ? new FakeArcaneWorkbenchInventory((Container)new ContainerFake(), 5, 3) : new InventoryCrafting((Container)new ContainerFake(), 3, 3);
            int recipeWidth = -1;
            if (recipe instanceof IShapedRecipe) {
                recipeWidth = ((IShapedRecipe)recipe).getRecipeWidth();
            }
            int slot = 0;
            boolean bail = false;
            try {
                for (Ingredient ingredient : recipe.func_192400_c()) {
                    boolean isEmpty;
                    boolean bl = isEmpty = ingredient == Ingredient.field_193370_a;
                    if (!isEmpty && ingredient.func_193365_a().length == 0) {
                        return null;
                    }
                    ItemStack stack = isEmpty ? ItemStack.field_190927_a : ingredient.func_193365_a()[0].func_77946_l();
                    ret.func_70299_a(slot++, stack);
                    if (recipeWidth <= 0 || slot % 3 % recipeWidth != 0) continue;
                    slot += 3 - recipeWidth;
                }
            }
            catch (Exception ex) {
                if (BROKEN_RECIPES.add(recipe.getRegistryName())) {
                    ThaumcraftFix.instance.getLogger().error("Failed setting crafting grid slots (recipe might have lied about fitting in a 3x3 grid)", (Throwable)ex);
                    ThaumcraftFix.instance.getLogger().error("Note: future errors with this recipe will not be logged");
                }
                bail = true;
            }
            matches = false;
            if (!bail) {
                IArcaneRecipe arcane;
                if (recipe instanceof IArcaneRecipe && (arcane = (IArcaneRecipe)recipe).getCrystals() != null) {
                    for (ShardType shard : ShardType.values()) {
                        if (shard.getMetadata() >= 6 || arcane.getCrystals().getAmount(shard.getAspect()) <= 0) continue;
                        ret.func_70299_a(shard.getMetadata() + 9, ThaumcraftApiHelper.makeCrystal((Aspect)shard.getAspect(), (int)arcane.getCrystals().getAmount(shard.getAspect())));
                    }
                }
                try {
                    matches = recipe.func_77569_a((InventoryCrafting)ret, null);
                }
                catch (Exception ex) {
                    if (!BROKEN_RECIPES.add(recipe.getRegistryName())) break block12;
                    ThaumcraftFix.instance.getLogger().error("Failed calling IRecipe#matches", (Throwable)ex);
                    ThaumcraftFix.instance.getLogger().error("Note: future errors with this recipe will not be logged");
                }
            }
        }
        return matches ? ret : null;
    }
}

