/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import baubles.api.cap.BaublesCapabilities;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.tools.ItemHandMirror;

public class ItemTransformersHooksCommon {
    public static boolean shouldAllowRunicShield(ItemStack stack) {
        return stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
    }

    private static int[] getValidMetadata(Item item) {
        IntRBTreeSet visitedMeta = new IntRBTreeSet();
        for (CreativeTabs tab : item.getCreativeTabs()) {
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(tab, stacks);
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() != item) continue;
                visitedMeta.add(stack.func_77960_j());
            }
        }
        return visitedMeta.toIntArray();
    }

    public static ItemStack cycleItemStack(ItemStack fallback, Object thing, int counter) {
        int[] validMeta;
        ItemStack stack;
        if (thing instanceof ItemStack && !(stack = (ItemStack)thing).func_190926_b() && stack.func_77981_g() && stack.func_77960_j() == Short.MAX_VALUE && (validMeta = ItemTransformersHooksCommon.getValidMetadata(stack.func_77973_b())).length > 0) {
            int timer = 5000 / validMeta.length;
            int metaIndex = (int)(((long)counter + System.currentTimeMillis() / (long)timer) % (long)validMeta.length);
            ItemStack copy = stack.func_77946_l();
            copy.func_77964_b(validMeta[metaIndex]);
            return copy;
        }
        return fallback;
    }

    public static void setFocusStackColor(ItemStack maybeFocus) {
        Item item = maybeFocus.func_77973_b();
        if (item instanceof ItemFocus) {
            ((ItemFocus)item).getFocusColor(maybeFocus);
        }
    }

    public static int nullCheckTags(NBTTagCompound prime, NBTTagCompound other) {
        int result = 0;
        if (prime == null) {
            result = 2;
        } else if (other == null) {
            result = 1;
        }
        return result;
    }

    public static ItemStack getHandMirrorStack(ItemStack original, InventoryPlayer playerInv) {
        EntityPlayer player = playerInv.field_70458_d;
        ItemStack mirror = player.func_184614_ca();
        if (!(mirror.func_77973_b() instanceof ItemHandMirror) && !((mirror = player.func_184592_cb()).func_77973_b() instanceof ItemHandMirror)) {
            mirror = ItemStack.field_190927_a;
        }
        if (mirror.func_190926_b()) {
            player.func_71053_j();
        }
        return mirror;
    }

    public static int getItemConsumeAmount(int original, EntityLivingBase entity) {
        return entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() ? 0 : original;
    }

    public static boolean skipGivingPhial(EntityPlayer player) {
        return player.func_184812_l_();
    }

    public static boolean elementalShovelWrapSetBlockStateForBlockPlacement(World world, BlockPos pos, IBlockState state, Operation<Boolean> op, EntityPlayer player, World worldAgain, BlockPos origPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, @Share(value="goodItem") LocalRef<ItemStack> goodItem, @Share(value="didSomething") LocalBooleanRef didSomething) {
        boolean result = false;
        ItemStack item = (ItemStack)goodItem.get();
        float modHitX = hitX + (float)(pos.func_177958_n() - origPos.func_177958_n());
        float modHitY = hitY + (float)(pos.func_177956_o() - origPos.func_177956_o());
        float modHitZ = hitZ + (float)(pos.func_177952_p() - origPos.func_177952_p());
        IBlockState toPlace = state.func_177230_c().getStateForPlacement(world, pos, side, modHitX, modHitY, modHitZ, item.func_77960_j(), (EntityLivingBase)player, hand);
        IBlockState existing = world.func_180495_p(pos);
        if (existing.func_177230_c().func_176200_f((IBlockAccess)world, pos) && player.func_175151_a(pos, side, item) && world.func_190527_a(state.func_177230_c(), pos, false, side, (Entity)player)) {
            if (item.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)item.func_77973_b();
                result = itemBlock.placeBlockAt(item, player, world, pos, side, modHitX, modHitY, modHitZ, toPlace);
            } else {
                result = (Boolean)op.call(new Object[]{toPlace, pos});
            }
        }
        if (result) {
            didSomething.set(true);
        }
        return result;
    }
}

