/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.entities.construct.EntityArcaneBore;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.utils.Utils;
import thecodex6824.thaumcraftfix.api.event.EntityInOuterLandsEvent;
import thecodex6824.thaumcraftfix.api.event.FluxRiftDestroyBlockEvent;
import thecodex6824.thaumcraftfix.common.util.NoEquipSoundFakePlayer;

public class EntityTransformersHooksCommon {
    private static Field FAKE_PLAYER_MAP = null;

    public static int isInOuterLands(int entityDim, Entity entity) {
        EntityInOuterLandsEvent event = new EntityInOuterLandsEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        boolean pass = event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && entity.func_130014_f_().field_73011_w.getDimension() == ModConfig.CONFIG_WORLD.dimensionOuterId;
        return pass ? entityDim : entityDim + 1;
    }

    public static void clearDropChances(EntityLiving entity) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            entity.func_184642_a(slot, 0.0f);
        }
    }

    public static boolean isEntityDeadForProcessInteract(boolean original, EntityLivingBase entity) {
        return original || entity.func_110143_aJ() <= 1.0E-5f;
    }

    public static boolean fireFluxRiftDestroyBlockEvent(EntityFluxRift rift, BlockPos pos, IBlockState state) {
        return MinecraftForge.EVENT_BUS.post((Event)new FluxRiftDestroyBlockEvent(rift, pos, state));
    }

    public static EntityArrow fireArrow(EntityLivingBase shooter, float range) {
        ItemStack arrow = shooter.func_184614_ca();
        EntityArrow entity = null;
        if (arrow.func_77973_b() instanceof ItemArrow && (entity = ((ItemArrow)arrow.func_77973_b()).func_185052_a(shooter.func_130014_f_(), arrow, shooter)).func_70242_d() < 2.25) {
            entity.func_70239_b(2.25 + (double)(range * 2.0f) + shooter.func_70681_au().nextGaussian() * 0.25);
        }
        return entity;
    }

    public static boolean isArrowInfinite(EntityLivingBase shooter) {
        EntityPlayer fakePlayer = null;
        if (shooter instanceof EntityPlayer) {
            fakePlayer = (EntityPlayer)shooter;
        } else if (!shooter.func_130014_f_().field_72995_K) {
            String fakeUsername = "TF";
            if (shooter instanceof IEntityOwnable && ((IEntityOwnable)shooter).func_184753_b() != null) {
                if ((fakeUsername = fakeUsername + Long.toHexString(((IEntityOwnable)shooter).func_184753_b().getLeastSignificantBits())).length() > 16) {
                    fakeUsername = fakeUsername.substring(0, 16);
                }
            } else {
                fakeUsername = fakeUsername + "UnownedCrssbw";
            }
            fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)shooter.func_130014_f_()), (GameProfile)new GameProfile(null, fakeUsername));
            fakePlayer.func_70029_a(shooter.func_130014_f_());
            ((FakePlayer)fakePlayer).field_71134_c.func_73080_a((WorldServer)shooter.func_130014_f_());
        }
        ItemStack arrow = shooter.func_184614_ca();
        return arrow.func_77973_b() instanceof ItemArrow ? Boolean.valueOf(((ItemArrow)arrow.func_77973_b()).isInfinite(arrow, new ItemStack((Item)Items.field_151031_f), fakePlayer)) : null;
    }

    private static void setFakePlayerMapEntry(FakePlayer toInsert) {
        try {
            if (FAKE_PLAYER_MAP == null) {
                FAKE_PLAYER_MAP = FakePlayerFactory.class.getDeclaredField("fakePlayers");
                FAKE_PLAYER_MAP.setAccessible(true);
            }
            ((Map)FAKE_PLAYER_MAP.get(null)).put(toInsert.func_146103_bH(), toInsert);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FakePlayer makeBoreFakePlayer(FakePlayer original, EntityArcaneBore bore) {
        int destructive;
        float radiusLeft;
        if (!(original instanceof NoEquipSoundFakePlayer)) {
            NoEquipSoundFakePlayer newPlayer = new NoEquipSoundFakePlayer(original.func_71121_q(), original.func_146103_bH());
            EntityTransformersHooksCommon.setFakePlayerMapEntry(newPlayer);
            original = newPlayer;
        }
        original.func_70095_a((radiusLeft = (float)bore.getDigRadius() - bore.currentRadius) <= (float)(destructive = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.DESTRUCTIVE)));
        return original;
    }

    public static boolean isBoreTargetAir(World world, BlockPos target, boolean original, EntityArcaneBore bore) {
        boolean air = world.func_175623_d(target);
        if (air && world.func_175699_k(target) < 10 && EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.LAMPLIGHT) > 0) {
            world.func_175656_a(target, BlocksTC.effectGlimmer.func_176223_P());
        }
        return air;
    }

    public static int modSpiral(int old, EntityArcaneBore bore) {
        int radMod = Math.max(0, (10 - Math.abs((int)bore.currentRadius)) * 2);
        return old - radMod;
    }

    public static float modCurrentRadius(float old, EntityArcaneBore bore) {
        int spiralStep = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.DESTRUCTIVE) * 2;
        return old + (float)spiralStep;
    }

    public static float modCurrentRadiusReset(float zero, EntityArcaneBore bore) {
        int spiralStep = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.DESTRUCTIVE) * 2 + 1;
        return spiralStep > 1 ? (bore.currentRadius - (float)bore.getDigRadius()) % (float)spiralStep : 0.0f;
    }

    public static Vec3d modRotation(Vec3d old, EntityArcaneBore bore) {
        EnumFacing facing = bore.getFacing();
        Vec3d src = new Vec3d((double)MathHelper.func_76128_c((double)bore.field_70165_t) + 0.5 + (double)facing.func_82601_c(), (double)MathHelper.func_76128_c((double)bore.field_70163_u) + 0.5 + (double)facing.func_96559_d(), (double)MathHelper.func_76128_c((double)bore.field_70161_v) + 0.5 + (double)facing.func_82599_e());
        Vec3d vec = new Vec3d(0.0, (double)bore.currentRadius, 0.0);
        vec = Utils.rotateAroundZ((Vec3d)vec, (float)((float)Math.toRadians(bore.spiral)));
        vec = facing.func_176740_k() != EnumFacing.Axis.Y ? Utils.rotateAroundY((Vec3d)vec, (float)((float)Math.toRadians(facing.func_185119_l()))) : Utils.rotateAroundX((Vec3d)vec, (float)(1.5707964f * (float)facing.func_96559_d()));
        Vec3d res = src.func_72441_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        return res;
    }

    public static double getFixedDistanceSq(EntityArcaneBore bore, BlockPos target, double old) {
        return target.func_177957_d((double)MathHelper.func_76128_c((double)bore.field_70165_t) + 0.5, (double)MathHelper.func_76128_c((double)bore.field_70163_u) + 0.5, (double)MathHelper.func_76128_c((double)bore.field_70161_v) + 0.5);
    }
}

