/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.renderers.models.gear.ModelCustomArmor;
import thaumcraft.common.entities.construct.EntityArcaneBore;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;

@SideOnly(value=Side.CLIENT)
public class EntityTransformersHooksClient {
    public static void correctRotationPoints(ModelBiped model) {
        if (model instanceof ModelCustomArmor) {
            if (model.field_78117_n) {
                model.field_178721_j.field_78797_d = 13.0f;
                model.field_178722_k.field_78797_d = 13.0f;
                model.field_78116_c.field_78797_d = 4.5f;
                model.field_78115_e.field_78797_d = 4.5f;
                model.field_178723_h.field_78797_d = 5.0f;
                model.field_178724_i.field_78797_d = 5.0f;
            } else {
                model.field_78115_e.field_78797_d = 0.0f;
                model.field_178723_h.field_78797_d = 2.0f;
                model.field_178724_i.field_78797_d = 2.0f;
            }
            model.field_178720_f.field_78800_c = model.field_78116_c.field_78800_c;
            model.field_178720_f.field_78797_d = model.field_78116_c.field_78797_d;
            model.field_178720_f.field_78798_e = model.field_78116_c.field_78798_e;
        }
    }

    public static TextureAtlasSprite getBlockParticleTexture(TextureAtlasSprite old, IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).func_177554_e();
    }

    private static boolean boreHasLamplighter(EntityArcaneBore bore) {
        ItemStack held = bore.func_184614_ca();
        return !held.func_190926_b() && EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)held, (EnumInfusionEnchantment)EnumInfusionEnchantment.LAMPLIGHT) > 0;
    }

    public static boolean doesBoreHaveProperties(EntityArcaneBore bore, boolean original) {
        return original || EntityTransformersHooksClient.boreHasLamplighter(bore);
    }

    public static int drawLamplightText(EntityArcaneBore bore, int position) {
        if (EntityTransformersHooksClient.boreHasLamplighter(bore)) {
            String text = I18n.func_135052_a((String)"enchantment.infusion.LAMPLIGHT", (Object[])new Object[0]);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(text, 4.0f, (float)(34 + position), 0xFFFF00);
            position += 9;
        }
        return position;
    }
}

