/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thecodex6824.thaumcraftfix.api.casting.IContainsFocusPackageNode;

public class CastingTransformersHooks {
    private static Collection<FocusPackage> getEmbeddedPackages(IFocusElement node) {
        ArrayList embeddedPackages = null;
        if (node instanceof IContainsFocusPackageNode) {
            embeddedPackages = ((IContainsFocusPackageNode)node).getEmbeddedPackages();
        } else if (node instanceof FocusModSplit) {
            embeddedPackages = ((FocusModSplit)node).getSplitPackages();
        }
        return embeddedPackages;
    }

    public static void initializeFocusPackage(FocusPackage focusPackage, EntityLivingBase caster) {
        focusPackage.setCasterUUID(caster.func_110124_au());
        for (IFocusElement node : focusPackage.nodes) {
            Collection<FocusPackage> embeddedPackages = CastingTransformersHooks.getEmbeddedPackages(node);
            if (embeddedPackages == null) continue;
            embeddedPackages.forEach(p -> p.initialize(caster));
        }
    }

    public static void setFocusPackageCasterUUID(FocusPackage focusPackage, UUID caster) {
        for (IFocusElement node : focusPackage.nodes) {
            Collection<FocusPackage> embeddedPackages = CastingTransformersHooks.getEmbeddedPackages(node);
            if (embeddedPackages == null) continue;
            embeddedPackages.forEach(p -> p.setCasterUUID(caster));
        }
    }
}

