/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.hooks;

import com.google.common.collect.Streams;
import com.google.common.math.DoubleMath;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusMedium;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.common.container.ContainerArcaneWorkbench;
import thaumcraft.common.tiles.crafting.FocusElementNode;
import thaumcraft.common.tiles.crafting.TileArcaneWorkbench;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;
import thaumcraft.common.tiles.devices.TileInfernalFurnace;
import thecodex6824.thaumcraftfix.ThaumcraftFix;

public class BlockTransformersHooksCommon {
    public static int modifyManipulatorComponentCount(int originalCount, TileFocalManipulator tile, AspectList crystals, EntityPlayer crafter) {
        int result;
        int n = result = crafter.func_184812_l_() ? -1 : originalCount;
        if (result < 0) {
            tile.crystalsSync = crystals.copy();
        }
        return result;
    }

    public static int recalcManipulatorXpCost(int totalComplexity) {
        return (int)Math.max(1L, Math.round(Math.sqrt(totalComplexity)));
    }

    public static BlockFaceShape getTableBlockFaceShape(BlockFaceShape original, EnumFacing side) {
        return side == EnumFacing.UP && original == BlockFaceShape.UNDEFINED ? BlockFaceShape.SOLID : original;
    }

    public static boolean isArcaneWorkbenchNotAllowed(boolean original, World world, BlockPos pos, EntityPlayer player) {
        boolean notAllowed = original;
        if (!notAllowed) {
            TileEntity tile = world.func_175625_s(pos);
            boolean bl = notAllowed = !(tile instanceof TileArcaneWorkbench) || ((TileArcaneWorkbench)tile).inventoryCraft.field_70465_c instanceof ContainerArcaneWorkbench;
            if (notAllowed && player != null) {
                player.func_146105_b(new TextComponentTranslation("thaumcraftfix.alreadyinuse", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
            }
        }
        return notAllowed;
    }

    public static boolean isArcaneWorkbenchNotAllowedForCharger(boolean original, World world, BlockPos pos, EntityPlayer player) {
        boolean notAllowed = original;
        if (!notAllowed) {
            BlockPos real = pos.func_177977_b();
            IBlockState state = world.func_180495_p(real);
            notAllowed = state.func_177230_c() == BlocksTC.arcaneWorkbench && BlockTransformersHooksCommon.isArcaneWorkbenchNotAllowed(original, world, real, player);
        }
        return notAllowed;
    }

    public static Iterator<FocusElementNode> getNodesInTree(Iterator<FocusElementNode> nodeIterator, HashMap<Integer, FocusElementNode> allNodes, int selectedNode) {
        FocusElementNode original;
        Set allowedNodes = Collections.newSetFromMap(new IdentityHashMap());
        FocusElementNode cursor = original = allNodes.get(selectedNode);
        allowedNodes.add(cursor);
        while (cursor.parent != -1) {
            cursor = allNodes.get(cursor.parent);
            allowedNodes.add(cursor);
        }
        ArrayDeque<FocusElementNode> nodesStack = new ArrayDeque<FocusElementNode>();
        nodesStack.add(original);
        while (!nodesStack.isEmpty()) {
            FocusElementNode node = (FocusElementNode)nodesStack.pop();
            allowedNodes.add(node);
            for (int child : node.children) {
                nodesStack.push(allNodes.get(child));
            }
        }
        return Streams.stream(nodeIterator).filter(allowedNodes::contains).iterator();
    }

    private static boolean canParentSupplyAll(FocusNode parent, FocusNode child) {
        for (FocusNode.EnumSupplyType type : child.mustBeSupplied()) {
            if (parent.canSupply(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFocus(TileFocalManipulator tile, EntityPlayer player, int maxComplexity, int computedComplexity) {
        boolean result = true;
        Logger logger = ThaumcraftFix.instance.getLogger();
        if (computedComplexity > maxComplexity) {
            result = false;
            logger.warn("Player {} ({}) tried to make a focus of complexity {} when the focus has a maximum complexity of {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)computedComplexity, (Object)maxComplexity);
        }
        if (result) {
            List leafNodes = tile.data.values().stream().filter(n -> n.children.length == 0).collect(Collectors.toList());
            block0: for (FocusElementNode leaf : leafNodes) {
                boolean rootFound = false;
                boolean mediumFound = false;
                HashSet<String> bannedNodes = new HashSet<String>();
                while (leaf != null && leaf.node != null) {
                    FocusElementNode directParent;
                    FocusElementNode focusElementNode = directParent = leaf.parent != -1 ? (FocusElementNode)tile.data.get(leaf.parent) : null;
                    if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{leaf.node.getResearch()})) {
                        result = false;
                        logger.warn("Player {} ({}) tried to make a focus without required research {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)leaf.node.getResearch());
                        continue block0;
                    }
                    if (directParent != null && directParent.node != null && !BlockTransformersHooksCommon.canParentSupplyAll(directParent.node, leaf.node)) {
                        result = false;
                        logger.warn("Player {} ({}) tried to make a focus with an invalid parent -> child node combo {} -> {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)directParent.node.getKey(), (Object)leaf.node.getKey());
                        continue block0;
                    }
                    if (leaf.node.getKey().equals("ROOT")) {
                        if (rootFound) {
                            result = false;
                            logger.warn("Player {} ({}) tried to make a focus with multiple root nodes", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString());
                            continue block0;
                        }
                        rootFound = true;
                    } else if (leaf.node instanceof FocusMedium && !bannedNodes.isEmpty() && leaf.node.isExclusive() && mediumFound) {
                        result = false;
                        logger.warn("Player {} ({}) tried to make a focus with illegal mediums", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString());
                    } else {
                        if (leaf.node.isExclusive() && !bannedNodes.add(leaf.node.getKey())) {
                            result = false;
                            logger.warn("Player {} ({}) tried to make a focus with illegal nodes", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString());
                            continue block0;
                        }
                        if (leaf.node instanceof FocusMedium) {
                            mediumFound = true;
                        }
                    }
                    leaf = directParent;
                }
            }
        }
        if (!result) {
            tile.vis = 0.0f;
        }
        return result;
    }

    public static float handleFocalManipulatorVis(float vis) {
        if (DoubleMath.fuzzyEquals((double)vis, (double)0.0, (double)1.0E-4)) {
            vis = 0.0f;
        }
        return vis;
    }

    public static ItemStack passStackToFurnace(ItemStack original, Entity item) {
        return item.field_70128_L ? ItemStack.field_190927_a : original;
    }

    public static ItemStack getStackToSet(ItemStack original, Entity item) {
        item.func_70106_y();
        return ((EntityItem)item).func_92059_d();
    }

    public static void destroyItemEffectsThatActuallyWork(TileInfernalFurnace furnace) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        BlockPos pos = furnace.func_174877_v();
        World world = furnace.func_145831_w();
        world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
        float pX = (float)pos.func_177958_n() + rand.nextFloat();
        float pY = (float)pos.func_177956_o() + 0.5f;
        float pZ = (float)pos.func_177952_p() + rand.nextFloat();
        SPacketParticles packet = new SPacketParticles(EnumParticleTypes.LAVA, false, pX, pY, pZ, 0.0f, 0.0f, 0.0f, 0.0f, rand.nextInt(3) + 2, new int[0]);
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            double dZ;
            double dY;
            double dX;
            if (player.field_71093_bK != world.field_73011_w.getDimension() || !((dX = (double)pX - player.field_70165_t) * dX + (dY = (double)pY - (player.field_70163_u + (double)player.eyeHeight)) * dY + (dZ = (double)pZ - player.field_70161_v) * dZ < 4096.0)) continue;
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }
}

