/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;
import thecodex6824.coremodlib.ASMUtil;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.core.ThaumcraftFixCore;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;

public class GenericStateMachineTransformer
implements ITransformer {
    private PatchStateMachine machine;
    private boolean required;
    private int limit;
    private String cachedTargetClass;

    public GenericStateMachineTransformer(PatchStateMachine machine) {
        this(machine, true, -1);
    }

    public GenericStateMachineTransformer(PatchStateMachine machine, boolean requireMatch, int limit) {
        this.machine = machine;
        this.required = requireMatch;
        this.limit = limit;
        this.cachedTargetClass = machine.targetMethod().declaringClass().replace("/", ".");
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return this.cachedTargetClass.equals(transformedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTransformerReport(MethodDefinition method, InsnList originalBytecode, List<PatchStateMachine.EvaluationResult> results) {
        StringJoiner output = new StringJoiner(System.lineSeparator());
        try {
            output.add("Begin bytecode transformer execution report:");
            output.add(String.format("Target method: %s", method.toString()));
            output.add("Original bytecode:");
            TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
            originalBytecode.accept((MethodVisitor)visitor);
            StringWriter writer = new StringWriter();
            visitor.p.print(new PrintWriter(writer));
            output.add(writer.toString());
            output.add("Patch state machine execution trace:");
            for (PatchStateMachine.EvaluationResult result : results) {
                output.add(result.toString());
            }
        }
        finally {
            ThaumcraftFixCore.getLogger().error(output.toString());
        }
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        boolean crashGame;
        InsnList instructionsStartingCopy;
        MethodNode theMethod = TransformUtil.findMethod(classNode, this.machine.targetMethod());
        if (theMethod == null) {
            Logger logger = ThaumcraftFixCore.getLogger();
            logger.error("Transformer target method {} not found in class {}, dumping entire class for debugging", (Object)this.machine.targetMethod().toString(), (Object)classNode.name);
            StringWriter writer = new StringWriter();
            TraceClassVisitor visitor = new TraceClassVisitor(new PrintWriter(writer));
            classNode.accept((ClassVisitor)visitor);
            logger.error(writer.toString());
            throw new IllegalArgumentException(String.format("Target method %s does not exist in the provided class %s", this.machine.targetMethod().toString(), classNode.name));
        }
        InsnList instructionsWorkingCopy = instructionsStartingCopy = ASMUtil.cloneInsnList(theMethod.instructions);
        boolean didSomething = false;
        boolean incomplete = false;
        ArrayList<PatchStateMachine.EvaluationResult> results = new ArrayList<PatchStateMachine.EvaluationResult>();
        Set<AbstractInsnNode> visitedNodes = Collections.newSetFromMap(new IdentityHashMap());
        int count = 0;
        while (true) {
            PatchStateMachine.EvaluationResult result = this.machine.evaluate(theMethod, visitedNodes);
            results.add(result);
            if (!result.evaluationFullyCompleted()) {
                incomplete = result.evaluationHadAnyMatch();
                break;
            }
            didSomething = true;
            if (this.limit >= 0 && ++count >= this.limit) break;
            instructionsWorkingCopy = ASMUtil.cloneInsnList(theMethod.instructions);
        }
        boolean bl = crashGame = !didSomething && this.required;
        if (crashGame || ThaumcraftFixCore.isDebugEnabled()) {
            if (results.size() > 1 && this.limit < 0) {
                results.remove(results.size() - 1);
            }
            this.printTransformerReport(this.machine.targetMethod(), instructionsStartingCopy, results);
            if (crashGame) {
                throw new RuntimeException("Fatal class transformer error");
            }
        }
        if (incomplete) {
            theMethod.instructions = instructionsWorkingCopy;
        }
        return didSomething;
    }
}

