/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.coremodlib.FieldAccessType;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.MatchDetails;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;
import thecodex6824.thaumcraftfix.core.transformer.Types;
import thecodex6824.thaumcraftfix.core.transformer.custom.ChangeVariableTypeTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.EntityAspectPrefixRemoverTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.ThrowingTransformerWrapper;

public class EntityTransformers {
    private static final String HOOKS_BASE = "thecodex6824/thaumcraftfix/core/transformer/hooks/EntityTransformersHooks";
    private static final String HOOKS_COMMON = "thecodex6824/thaumcraftfix/core/transformer/hooks/EntityTransformersHooksCommon";
    private static final String HOOKS_CLIENT = "thecodex6824/thaumcraftfix/core/transformer/hooks/EntityTransformersHooksClient";
    public static final ITransformer ELDRITCH_GUARDIAN_FOG = new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/monster/EntityEldritchGuardian", false, "func_70071_h_", Type.VOID_TYPE, new Type[0]))).findConsecutive().findNextMethodCall(new MethodDefinition("net/minecraft/world/WorldProvider", false, "getDimension", Type.INT_TYPE, new Type[0]))).findNextFieldAccess(new FieldDefinition("thaumcraft/common/config/ModConfig$CONFIG_WORLD", "dimensionOuterId", Type.INT_TYPE))).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, "thecodex6824/thaumcraftfix/core/transformer/hooks/EntityTransformersHooksCommon", "isInOuterLands", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Types.ENTITY}), false)}).build());
    public static final Supplier<ITransformer> ENTITY_ASPECTS = () -> new ThrowingTransformerWrapper(new EntityAspectPrefixRemoverTransformer());
    public static final Supplier<ITransformer> ADVANCED_CROSSBOW_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/entities/construct/EntityTurretCrossbowAdvanced");
    public static final Supplier<ITransformer> BORE_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer(Types.ENTITY_ARCANE_BORE.getInternalName());
    public static final Supplier<ITransformer> CROSSBOW_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/entities/construct/EntityTurretCrossbow");
    public static final Supplier<ITransformer> GOLEM_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/golems/EntityThaumcraftGolem");
    public static final Supplier<ITransformer> OWNED_CONSTRUCT_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/entities/construct/EntityOwnedConstruct");
    public static final Supplier<ITransformer> OWNED_CONSTRUCT_ZERO_DROP_CHANCES = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/entities/construct/EntityOwnedConstruct", false, "<init>", Type.VOID_TYPE, Types.WORLD)).findNextOpcode(177)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "clearDropChances", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.ENTITY_LIVING}), false)}).build());
    public static final Supplier<ITransformer> PECH_ADD_STACK = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/container/ContainerPech", false, "addStack", Type.VOID_TYPE, Types.ITEM_STACK)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ITEM_STACK.getInternalName(), false, "func_190917_f", Type.VOID_TYPE, Type.INT_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new InsnNode(177)}).build());
    public static final ITransformer VOID_ROBE_ARMOR_DISPLAY = new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/items/armor/ItemVoidRobeArmor", false, "getArmorDisplay", Type.INT_TYPE, Types.ENTITY_PLAYER, Types.ITEM_STACK, Type.INT_TYPE)).findNextOpcode(172)).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(3)}).build());
    public static final ITransformer FLUX_RIFT_DESTROY_BLOCK_EVENT = new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/EntityFluxRift", false, "func_70071_h_", Type.VOID_TYPE, new Type[0]))).findConsecutive().findNextLocalAccess(0)).findNextFieldAccess(TransformUtil.remapField(new FieldDefinition("thaumcraft/common/entities/EntityFluxRift", "field_70170_p", Types.WORLD)))).findNextLocalAccess(5)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.WORLD.getInternalName(), false, "func_175623_d", Type.BOOLEAN_TYPE, Types.BLOCK_POS)))).findNextInstructionType(JumpInsnNode.class)).endConsecutive().insertInstructions((node, matches) -> {
        InsnList toAdd = new InsnList();
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 5));
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 6));
        toAdd.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_COMMON, "fireFluxRiftDestroyBlockEvent", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType((String)"Lthaumcraft/common/entities/EntityFluxRift;"), Types.BLOCK_POS, Types.I_BLOCK_STATE}), false));
        JumpInsnNode originalJump = (JumpInsnNode)((MatchDetails)matches.get(0)).matchEnd();
        toAdd.add((AbstractInsnNode)new JumpInsnNode(originalJump.getOpcode(), originalJump.label));
        ImmutableList added = ImmutableList.copyOf((Iterator)toAdd.iterator());
        node.instructions.insertBefore(((MatchDetails)matches.get(0)).matchStart(), toAdd);
        return added;
    }).build());
    public static final Supplier<ITransformer> BORE_FIX_RUMBLE_AND_LAMPLIGHT = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "dig", Type.BOOLEAN_TYPE, new Type[0])).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.WORLD.getInternalName(), false, "func_175698_g", Type.BOOLEAN_TYPE, Types.BLOCK_POS)))).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isBoreTargetAir", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.WORLD, Types.BLOCK_POS, Type.BOOLEAN_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).endAction().build());
    public static final Supplier<ITransformer> BORE_GUI_PROPERTIES = () -> {
        MethodDefinition hasSilkTouch = new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "hasSilkTouch", Type.BOOLEAN_TYPE, new Type[0]);
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/client/gui/GuiArcaneBore", false, "func_146976_a", Type.VOID_TYPE, Type.FLOAT_TYPE, Type.INT_TYPE, Type.INT_TYPE))).findNextMethodCall(hasSilkTouch)).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(89)}).after(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS_CLIENT, "doesBoreHaveProperties", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.ENTITY_ARCANE_BORE, Type.BOOLEAN_TYPE}), false)}).endAction().findNextMethodCall(hasSilkTouch)).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(89), new VarInsnNode(21, 8), new MethodInsnNode(184, HOOKS_CLIENT, "drawLamplightText", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Types.ENTITY_ARCANE_BORE, Type.INT_TYPE}), false), new VarInsnNode(54, 8)}).build());
    };
    public static final Supplier<ITransformer> BORE_NO_EQUIP_SOUND = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "dig", Type.BOOLEAN_TYPE, new Type[0])).findNextMethodCall(new MethodDefinition(Types.FAKE_PLAYER_FACTORY.getInternalName(), false, "get", Types.FAKE_PLAYER, Types.WORLD_SERVER, Types.GAME_PROFILE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "makeBoreFakePlayer", Type.getMethodDescriptor((Type)Types.FAKE_PLAYER, (Type[])new Type[]{Types.FAKE_PLAYER, Types.ENTITY_ARCANE_BORE}), false)}).build());
    public static final Supplier<ITransformer> BORE_PARTICLE_TEXTURE = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/client/fx/particles/FXBoreParticles", false, "<init>", Type.VOID_TYPE, Types.WORLD, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Types.I_BLOCK_STATE, Type.INT_TYPE)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/client/fx/particles/FXBoreParticles", false, "func_187117_a", Type.VOID_TYPE, Types.TEXTURE_ATLAS_SPRITE)))).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 14), new MethodInsnNode(184, HOOKS_CLIENT, "getBlockParticleTexture", Type.getMethodDescriptor((Type)Types.TEXTURE_ATLAS_SPRITE, (Type[])new Type[]{Types.TEXTURE_ATLAS_SPRITE, Types.I_BLOCK_STATE}), false)}).build());
    public static final Supplier<ITransformer> BORE_SPIRAL_TWEAKS = () -> {
        FieldDefinition currentRadius = new FieldDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), "currentRadius", Type.FLOAT_TYPE);
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "findNextBlockToDig", Type.VOID_TYPE, new Type[0])).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityArcaneBore", false, "func_174831_c", Type.DOUBLE_TYPE, Types.BLOCK_POS)))).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS_COMMON, "getFixedDistanceSq", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Types.ENTITY_ARCANE_BORE, Types.BLOCK_POS, Type.DOUBLE_TYPE}), false)}).endAction().findNextFieldAccess(new FieldDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), "spiral", Type.INT_TYPE), FieldAccessType.STORE)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modSpiral", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).findNextFieldAccess(currentRadius, FieldAccessType.STORE)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modCurrentRadius", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).findNextFieldAccess(currentRadius, FieldAccessType.STORE)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modCurrentRadiusReset", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).findNextMethodCall(new MethodDefinition("thaumcraft/common/lib/utils/Utils", false, "rotateAroundX", Types.VEC_3D, Types.VEC_3D, Type.FLOAT_TYPE))).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.VEC_3D.getInternalName(), false, "func_72441_c", Types.VEC_3D, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modRotation", Type.getMethodDescriptor((Type)Types.VEC_3D, (Type[])new Type[]{Types.VEC_3D, Types.ENTITY_ARCANE_BORE}), false)}).build());
    };
    public static final Supplier<ITransformer> CROSSBOW_FIRE_ARROW_CLASS = () -> new ThrowingTransformerWrapper(new ChangeVariableTypeTransformer(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityTurretCrossbow", false, "func_82196_d", Type.VOID_TYPE, Types.ENTITY_LIVING_BASE, Type.FLOAT_TYPE)), Types.ENTITY_TIPPED_ARROW, Types.ENTITY_ARROW, false, (Collection<String>)ImmutableSet.of((Object)TransformUtil.remapMethod(new MethodDefinition(Types.ENTITY_TIPPED_ARROW.getInternalName(), false, "func_184555_a", Type.VOID_TYPE, Types.ITEM_STACK)).name()), true));
    public static final Supplier<ITransformer> CROSSBOW_FIRE_ARROW_LOGIC = () -> {
        LabelNode afterArrowCreation = new LabelNode(new Label());
        LabelNode afterShrink = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityTurretCrossbow", false, "func_82196_d", Type.VOID_TYPE, Types.ENTITY_LIVING_BASE, Type.FLOAT_TYPE))).findNextNewObject(Types.ENTITY_TIPPED_ARROW)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ENTITY_TIPPED_ARROW.getInternalName(), false, "func_184555_a", Type.VOID_TYPE, Types.ITEM_STACK)))).combineLastTwoMatches().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new VarInsnNode(25, 0), new VarInsnNode(23, 2), new MethodInsnNode(184, HOOKS_COMMON, "fireArrow", Type.getMethodDescriptor((Type)Types.ENTITY_ARROW, (Type[])new Type[]{Types.ENTITY_LIVING_BASE, Type.FLOAT_TYPE}), false), new InsnNode(89), new JumpInsnNode(199, afterArrowCreation)}).after(new AbstractInsnNode[]{afterArrowCreation, new FrameNode(4, 0, null, 1, new Object[]{Types.ENTITY_ARROW.getInternalName()}), new VarInsnNode(58, 3)}).endAction().findConsecutive().findNextLocalAccess(0)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityTurretCrossbow", false, "func_184614_ca", Types.ITEM_STACK, new Type[0])))).findAny()).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ITEM_STACK.getInternalName(), false, "func_190918_g", Type.VOID_TYPE, Type.INT_TYPE)))).endConsecutive().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isArrowInfinite", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.ENTITY_LIVING_BASE}), false), new JumpInsnNode(154, afterShrink)}).after(new AbstractInsnNode[]{afterShrink, new FrameNode(3, 0, null, 0, null)}).endAction().build(), true, 1);
    };

    private static Supplier<ITransformer> makeEntityProcessInteractTransformer(String className) {
        return () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition(className, false, "func_184645_a", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.ENUM_HAND))).findNextFieldAccess(TransformUtil.remapField(new FieldDefinition(className, "field_70128_L", Type.BOOLEAN_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isEntityDeadForProcessInteract", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Types.ENTITY_LIVING_BASE}), false)}).build());
    }
}

