/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import thecodex6824.thaumcraftfix.core.ThaumcraftFixCore;
import thecodex6824.thaumcraftfix.core.transformer.BlockTransformers;
import thecodex6824.thaumcraftfix.core.transformer.CastingTransformers;
import thecodex6824.thaumcraftfix.core.transformer.EntityTransformers;
import thecodex6824.thaumcraftfix.core.transformer.FeatureTransformers;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.ItemTransformers;
import thecodex6824.thaumcraftfix.core.transformer.MiscTransformers;
import thecodex6824.thaumcraftfix.core.transformer.NetworkTransformers;
import thecodex6824.thaumcraftfix.core.transformer.ResearchTransformers;
import thecodex6824.thaumcraftfix.core.transformer.SoundTransformers;
import thecodex6824.thaumcraftfix.core.transformer.TheorycraftTransformers;
import thecodex6824.thaumcraftfix.core.transformer.WorldGenTransformers;

public class TransformerExecutor
implements IClassTransformer {
    private List<ITransformer> transformers = new ArrayList<ITransformer>();

    public TransformerExecutor() {
        if (!ThaumcraftFixCore.isOldThaumicAugmentationDetected()) {
            this.transformers.add(EntityTransformers.ELDRITCH_GUARDIAN_FOG);
            this.transformers.add(EntityTransformers.FLUX_RIFT_DESTROY_BLOCK_EVENT);
            this.transformers.add(EntityTransformers.VOID_ROBE_ARMOR_DISPLAY);
            this.transformers.add(ItemTransformers.CYCLE_ITEM_NON_DAMAGEABLE);
            this.transformers.add(ItemTransformers.RUNIC_SHIELD_INFUSION_BAUBLE_CAP);
            this.transformers.add(SoundTransformers.SOUND_FIX_CASTER_TICK.get());
            this.transformers.add(SoundTransformers.SOUND_FIX_JAR_FILL.get());
            this.transformers.add(SoundTransformers.SOUND_FIX_LOOT_BAG.get());
            this.transformers.add(SoundTransformers.SOUND_FIX_MIRROR_TRANSPORT.get());
            this.transformers.add(SoundTransformers.SOUND_FIX_MIRROR_USE.get());
            this.transformers.add(SoundTransformers.SOUND_FIX_PHIAL_FILL.get());
            this.transformers.add(SoundTransformers.SOUND_FIX_WIND_SWORD_USE.get());
        } else {
            ThaumcraftFixCore.getLogger().warn("An old version of Thaumic Augmentation was detected. Some of the fixes normally provided by Thaumcraft Fix will be handled by Thaumic Augmentation instead. Consider updating Thaumic Augmentation to version {} or newer, as Thaumcraft Fix will probably have better compatibility and less of a chance of issues occuring.", (Object)"2.1.14");
        }
        if (!ThaumcraftFixCore.isThaumicWandsDetected()) {
            this.transformers.add(BlockTransformers.ARCANE_WORKBENCH_NO_CONCURRENT_USE.get());
            this.transformers.add(BlockTransformers.ARCANE_WORKBENCH_NO_CONCURRENT_USE_CHARGER.get());
        }
        this.transformers.add(BlockTransformers.BRAIN_JAR_EAT_DELAY.get());
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_FOCUS_SLOT.get());
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_COMPONENTS);
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_COMPONENTS_CLIENT);
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_EXCLUSIVE_NODES_CLIENT.get());
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_SERVER_CHECKS.get());
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_VIS_FP_ISSUES.get());
        this.transformers.add(BlockTransformers.FOCAL_MANIPULATOR_XP_COST_GUI);
        this.transformers.add(BlockTransformers.INFERNAL_FURNACE_DESTROY_EFFECTS.get());
        this.transformers.add(BlockTransformers.INFERNAL_FURNACE_ITEM_CHECKS.get());
        this.transformers.add(BlockTransformers.PLANT_CINDERPEARL_OFFSET.get());
        this.transformers.add(BlockTransformers.PLANT_SHIMMERLEAF_OFFSET.get());
        this.transformers.add(BlockTransformers.TABLE_TOP_SOLID.get());
        this.transformers.add(BlockTransformers.THAUMATORIUM_TOP_EMPTY.get());
        this.transformers.add(CastingTransformers.EXCHANGE_MOD_INTERFACEIFY);
        this.transformers.add(CastingTransformers.FOCUS_PACKAGE_INIT);
        this.transformers.add(CastingTransformers.FOCUS_PACKAGE_SET_CASTER_UUID);
        this.transformers.add(CastingTransformers.TOUCH_MOD_AVOID_PLAYER_CAST_TARGET);
        this.transformers.add(CastingTransformers.TOUCH_MOD_AVOID_PLAYER_CAST_TRAJECTORY);
        this.transformers.add(EntityTransformers.ADVANCED_CROSSBOW_PROCESS_INTERACT_DEAD.get());
        this.transformers.add(EntityTransformers.BORE_FIX_RUMBLE_AND_LAMPLIGHT.get());
        this.transformers.add(EntityTransformers.BORE_GUI_PROPERTIES.get());
        this.transformers.add(EntityTransformers.BORE_NO_EQUIP_SOUND.get());
        this.transformers.add(EntityTransformers.BORE_PARTICLE_TEXTURE.get());
        this.transformers.add(EntityTransformers.BORE_PROCESS_INTERACT_DEAD.get());
        this.transformers.add(EntityTransformers.BORE_SPIRAL_TWEAKS.get());
        this.transformers.add(EntityTransformers.CROSSBOW_PROCESS_INTERACT_DEAD.get());
        this.transformers.add(EntityTransformers.ENTITY_ASPECTS.get());
        this.transformers.add(EntityTransformers.GOLEM_PROCESS_INTERACT_DEAD.get());
        this.transformers.add(EntityTransformers.PECH_ADD_STACK.get());
        this.transformers.add(EntityTransformers.OWNED_CONSTRUCT_PROCESS_INTERACT_DEAD.get());
        this.transformers.add(EntityTransformers.OWNED_CONSTRUCT_ZERO_DROP_CHANCES.get());
        this.transformers.add(EntityTransformers.CROSSBOW_FIRE_ARROW_CLASS.get());
        this.transformers.add(EntityTransformers.CROSSBOW_FIRE_ARROW_LOGIC.get());
        this.transformers.add(FeatureTransformers.GENERATE_AURA.get());
        this.transformers.add(FeatureTransformers.GENERATE_CRYSTALS.get());
        this.transformers.add(FeatureTransformers.GENERATE_VEGETATION.get());
        this.transformers.add(ItemTransformers.COMPARE_TAGS_RELAXED_NULL_CHECK.get());
        this.transformers.add(ItemTransformers.FOCUS_COLOR_NBT.get());
        this.transformers.add(ItemTransformers.HAND_MIRROR_STACK_CONTAINER.get());
        this.transformers.add(ItemTransformers.HAND_MIRROR_STACK_GUI.get());
        this.transformers.add(ItemTransformers.INFUSION_ENCHANTMENT_DROPS_PRIORITY.get());
        this.transformers.add(ItemTransformers.PHIAL_CONSUMPTION_CREATIVE.get());
        this.transformers.add(ItemTransformers.SANITY_SOAP_CREATIVE.get());
        this.transformers.add(MiscTransformers.ARCANE_WORKBENCH_RECIPE_COMPAT.get());
        this.transformers.add(MiscTransformers.ASPECT_REGISTRY_LOOKUP.get());
        this.transformers.add(MiscTransformers.ASPECT_RECIPE_MATCHES.get());
        this.transformers.add(MiscTransformers.OBJ_MODEL_NO_SCALA.get());
        this.transformers.add(NetworkTransformers.FOCAL_MANIPULATOR_DATA.get());
        this.transformers.add(NetworkTransformers.LOGISTICS_REQUEST.get());
        this.transformers.add(NetworkTransformers.NOTE_HANDLER.get());
        this.transformers.add(NetworkTransformers.RESEARCH_TABLE_AIDS.get());
        this.transformers.add(NetworkTransformers.THAUMATORIUM_RECIPE_SELECTION.get());
        this.transformers.add(ResearchTransformers.KNOWLEDGE_GAIN_EVENT_CLIENT.get());
        this.transformers.add(ResearchTransformers.PARSE_PAGE_FIRST_PASS.get());
        this.transformers.add(ResearchTransformers.RESEARCH_GAIN_EVENT_CLIENT.get());
        this.transformers.add(ResearchTransformers.RESEARCH_PATCHER.get());
        this.transformers.add(ResearchTransformers.SCAN_SKY_SCRIBE_CHECK.get());
        this.transformers.add(SoundTransformers.SOUND_FIX_FOCAL_MANIPULATOR_CONTAINER.get());
        this.transformers.add(TheorycraftTransformers.CARD_ANALYZE_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_CURIO_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_DARK_WHISPERS_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_DRAGON_EGG_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_EXPERIMENTATION_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_GLYPHS_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_PORTAL_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_REALIZATION_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.CARD_REVELATION_CATEGORIES.get());
        this.transformers.add(TheorycraftTransformers.RESEARCH_TABLE_DATA_CATEGORIES.get());
        this.transformers.add(WorldGenTransformers.MAGICAL_FOREST_DECORATE_CASCADING.get());
    }

    private boolean isTransformNeeded(String transformedName) {
        for (ITransformer t : this.transformers) {
            if (!t.isTransformationNeeded(transformedName)) continue;
            return true;
        }
        return false;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ThaumcraftFixCore.isInitComplete()) {
            return basicClass;
        }
        if (this.isTransformNeeded(transformedName)) {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(basicClass);
            reader.accept((ClassVisitor)node, 0);
            boolean didSomething = false;
            for (ITransformer transformer : this.transformers) {
                if (!transformer.isTransformationNeeded(transformedName)) continue;
                boolean transformerDidSomething = false;
                try {
                    transformerDidSomething = transformer.transform(node, name, transformedName);
                }
                catch (Throwable anything) {
                    ThaumcraftFixCore.getLogger().error("A class transformer has failed!");
                    ThaumcraftFixCore.getLogger().error("Class: " + transformedName + ", Transformer: " + transformer.getClass());
                    ThaumcraftFixCore.getLogger().error("Additional information: ", anything);
                    throw anything;
                }
                didSomething |= transformerDidSomething;
            }
            if (didSomething) {
                ClassWriter writer = new ClassWriter(1);
                node.accept((ClassVisitor)writer);
                ThaumcraftFixCore.getLogger().info("Successfully transformed class " + transformedName);
                return writer.toByteArray();
            }
        }
        return basicClass;
    }
}

