/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.Name(value="Thaumcraft Fix Core Plugin")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=1100)
@IFMLLoadingPlugin.TransformerExclusions(value={"thecodex6824.thaumcraftfix.core"})
public class ThaumcraftFixCore
implements IFMLLoadingPlugin {
    protected static final String AUG_GOOD_VERSION = "2.1.14";
    private static Logger log = LogManager.getLogger((String)"thaumcraftfixcore");
    private static boolean debug = false;
    private static boolean ready = false;
    private static boolean oldAug = false;
    private static boolean thaumicWands = false;

    public static Logger getLogger() {
        return log;
    }

    public static boolean isDebugEnabled() {
        return debug;
    }

    public static boolean isInitComplete() {
        return ready;
    }

    public static boolean isOldThaumicAugmentationDetected() {
        return oldAug;
    }

    public static boolean isThaumicWandsDetected() {
        return thaumicWands;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"thecodex6824.thaumcraftfix.core.TransformerExecutor"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        String debugProp = System.getProperty("thaumcraftfix.debug");
        boolean debugBoolTrue = Boolean.parseBoolean(debugProp);
        boolean debugIntTrue = false;
        if (!debugBoolTrue) {
            try {
                debugIntTrue = Integer.parseInt(debugProp) == 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        debug = debugBoolTrue || debugIntTrue;
        try {
            Class<?> augApi = Class.forName("thecodex6824.thaumicaugmentation.api.ThaumicAugmentationAPI");
            String apiVersion = (String)augApi.getField("API_VERSION").get(null);
            oldAug = new ComparableVersion(apiVersion).compareTo(new ComparableVersion(AUG_GOOD_VERSION)) < 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("de.zpenguin.thaumicwands.asm.ThaumicWandsCore");
            thaumicWands = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Mixins.addConfigurations((String[])ThaumcraftFixCore.getEarlyMixinConfigs().toArray(new String[0]));
        ready = true;
        log.info("Thaumcraft Fix coremod initialized");
    }

    public static List<String> getEarlyMixinConfigs() {
        return ImmutableList.of((Object)"mixin/vanilla.json");
    }

    public static List<String> getLateMixinConfigs() {
        return ImmutableList.of((Object)"mixin/aura.json", (Object)"mixin/block.json", (Object)"mixin/event.json", (Object)"mixin/focus.json", (Object)"mixin/item.json", (Object)"mixin/network.json", (Object)"mixin/render.json", (Object)"mixin/tile.json", (Object)"mixin/util.json");
    }
}

