/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.research.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ScanBlock;
import thaumcraft.api.research.ScanBlockState;
import thecodex6824.thaumcraftfix.api.scan.IScanParser;
import thecodex6824.thaumcraftfix.common.json.JsonSchemaException;
import thecodex6824.thaumcraftfix.common.json.JsonUtils;

public class ScanParserBlock
implements IScanParser {
    protected static <T extends Comparable<T>> IBlockState getStateWithProperty(IBlockState state, IProperty<T> prop, Comparable<?> val) {
        return state.func_177226_a(prop, (Comparable)prop.func_177699_b().cast(val));
    }

    @Nullable
    protected static IBlockState stateFromString(Block block, String str) {
        ImmutableMap map = null;
        if (str.equals("default")) {
            map = block.func_176223_P().func_177228_b();
        } else {
            if (str.startsWith("[") && str.endsWith("]")) {
                str = str.substring(1, str.length() - 1);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            BlockStateContainer container = block.func_176194_O();
            for (String s : str.split(",")) {
                String[] equalsSplit = s.split("=", 2);
                if (equalsSplit.length < 2) {
                    return null;
                }
                IProperty prop = container.func_185920_a(equalsSplit[0]);
                if (prop == null) {
                    return null;
                }
                Comparable comp = (Comparable)prop.func_185929_b(equalsSplit[1]).orNull();
                if (comp == null) {
                    return null;
                }
                builder.put((Object)prop, (Object)comp);
            }
            map = builder.build();
        }
        IBlockState state = block.func_176223_P();
        for (Map.Entry entry : map.entrySet()) {
            state = ScanParserBlock.getStateWithProperty(state, (IProperty)entry.getKey(), (Comparable)entry.getValue());
        }
        return state;
    }

    protected IScanThing parseElement(String key, JsonElement e) {
        if (e.isJsonArray()) {
            throw new JsonSchemaException(key + ": Invalid object entry: must be object or primitive");
        }
        if (e.isJsonPrimitive()) {
            ResourceLocation loc = new ResourceLocation(e.getAsString());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(loc);
            if (block == null) {
                throw new NullPointerException(key + ": Block " + loc + " does not exist");
            }
            return new ScanBlock(key, new Block[]{block});
        }
        ResourceLocation loc = new ResourceLocation(JsonUtils.getPrimitiveOrThrow("name", e.getAsJsonObject()).getAsString());
        JsonPrimitive state = (JsonPrimitive)JsonUtils.tryGetPrimitive("state", e.getAsJsonObject()).orNull();
        String blockstate = state != null ? state.getAsString() : null;
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(loc);
        if (block == null) {
            throw new NullPointerException(key + ": Block " + loc + " does not exist");
        }
        if (blockstate != null) {
            IBlockState bs = ScanParserBlock.stateFromString(block, blockstate);
            if (bs == null) {
                throw new NullPointerException(key + ": BlockState " + blockstate + " is invalid for " + block.func_176194_O());
            }
            return new ScanBlockState(key, bs);
        }
        return new ScanBlock(key, new Block[]{block});
    }

    @Override
    public boolean matches(ResourceLocation type) {
        return type.func_110624_b().equals("thaumcraft") && type.func_110623_a().equals("block");
    }

    @Override
    public Collection<IScanThing> parseScan(String key, ResourceLocation type, JsonElement input) {
        if (input.isJsonArray()) {
            ArrayList<IScanThing> things = new ArrayList<IScanThing>();
            for (JsonElement e : input.getAsJsonArray()) {
                things.add(this.parseElement(key, e));
            }
            return things;
        }
        return Lists.newArrayList((Object[])new IScanThing[]{this.parseElement(key, input)});
    }
}

