/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thecodex6824.thaumcraftfix.IProxy;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.event.PlayerGainKnowledgeEventClient;

public class PacketGainKnowledge
implements IMessage {
    private IPlayerKnowledge.EnumKnowledgeType type;
    private ResearchCategory category;
    private int amount;

    public PacketGainKnowledge() {
    }

    public PacketGainKnowledge(IPlayerKnowledge.EnumKnowledgeType type, @Nullable ResearchCategory category, int amount) {
        this.type = type;
        this.category = category;
        this.amount = amount;
    }

    public IPlayerKnowledge.EnumKnowledgeType type() {
        return this.type;
    }

    @Nullable
    public ResearchCategory category() {
        return this.category;
    }

    public int amount() {
        return this.amount;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = IPlayerKnowledge.EnumKnowledgeType.values()[buf.readByte()];
        this.amount = buf.readInt();
        String maybeCategory = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (!maybeCategory.isEmpty()) {
            this.category = ResearchCategories.getResearchCategory((String)maybeCategory);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.amount);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.category != null ? this.category.key : ""));
    }

    public static class Handler
    implements IMessageHandler<PacketGainKnowledge, IMessage> {
        public IMessage onMessage(PacketGainKnowledge message, MessageContext ctx) {
            IProxy proxy = ThaumcraftFix.proxy;
            proxy.scheduleTask(ctx.side, () -> {
                PlayerGainKnowledgeEventClient event = new PlayerGainKnowledgeEventClient(proxy.getClientPlayer(), message.type(), message.category(), message.amount());
                MinecraftForge.EVENT_BUS.post((Event)event);
            });
            return null;
        }
    }
}

