/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.common.json.JsonPatch;
import thecodex6824.thaumcraftfix.common.json.JsonSchemaException;
import thecodex6824.thaumcraftfix.common.json.JsonUtils;

public final class PatchHelper {
    private PatchHelper() {
    }

    private static JsonElement getValue(JsonElement parent, String child) throws JsonSchemaException {
        if (parent.isJsonObject()) {
            return parent.getAsJsonObject().get(child);
        }
        if (parent.isJsonArray()) {
            JsonArray array = parent.getAsJsonArray();
            int index = -1;
            if (child.equals("-")) {
                throw new JsonSchemaException("Path component - is not a valid array index here");
            }
            try {
                index = Integer.parseInt(child);
            }
            catch (NumberFormatException ex) {
                throw new JsonSchemaException("Path component " + child + " is not a valid array index");
            }
            if (index < 0 || index >= array.size()) {
                throw new JsonSchemaException("Path component " + child + " is not a valid array index");
            }
            return array.get(index);
        }
        return null;
    }

    private static void patchAdd(JsonElement parent, String child, JsonElement meta) throws JsonSchemaException {
        if (parent.isJsonObject()) {
            parent.getAsJsonObject().add(child, meta);
        } else if (parent.isJsonArray()) {
            JsonArray array = parent.getAsJsonArray();
            int index = -1;
            if (child.equals("-")) {
                index = array.size();
            } else {
                try {
                    index = Integer.parseInt(child);
                }
                catch (NumberFormatException ex) {
                    throw new JsonSchemaException("Path component " + child + " is not a valid array index");
                }
                if (index < 0 || index > array.size()) {
                    throw new JsonSchemaException("Path component " + child + " is not a valid array index");
                }
            }
            if (index == array.size()) {
                array.add(meta);
            } else {
                int i;
                JsonElement[] temp = new JsonElement[array.size() - index];
                for (i = index; i < array.size(); ++i) {
                    temp[i - index] = array.get(i);
                }
                array.set(index, meta);
                for (i = index + 1; i < array.size(); ++i) {
                    array.set(i, temp[i - index - 1]);
                }
                array.add(temp[temp.length - 1]);
            }
        }
    }

    @Nullable
    private static JsonElement patchRemove(JsonElement parent, String child) throws JsonSchemaException {
        if (parent.isJsonObject()) {
            return parent.getAsJsonObject().remove(child);
        }
        if (parent.isJsonArray()) {
            JsonArray array = parent.getAsJsonArray();
            int index = -1;
            if (child.equals("-")) {
                throw new JsonSchemaException("Path component - is not a valid array index for remove operations");
            }
            try {
                index = Integer.parseInt(child);
            }
            catch (NumberFormatException ex) {
                throw new JsonSchemaException("Path component " + child + " is not a valid array index");
            }
            if (index < 0 || index >= array.size()) {
                throw new JsonSchemaException("Path component " + child + " is not a valid array index");
            }
            return array.remove(index);
        }
        return null;
    }

    @Nullable
    private static JsonElement patchTest(JsonElement parent, String child) throws JsonSchemaException {
        if (parent.isJsonObject()) {
            return parent.getAsJsonObject().get(child);
        }
        if (parent.isJsonArray()) {
            JsonArray array = parent.getAsJsonArray();
            int index = -1;
            if (child.equals("-")) {
                throw new JsonSchemaException("Path component - is not a valid array index for test operations");
            }
            try {
                index = Integer.parseInt(child);
            }
            catch (NumberFormatException ex) {
                throw new JsonSchemaException("Path component " + child + " is not a valid array index");
            }
            if (index < 0 || index >= array.size()) {
                throw new JsonSchemaException("Path component " + child + " is not a valid array index");
            }
            return array.get(index);
        }
        return null;
    }

    @Nullable
    private static Pair<JsonElement, String> parsePath(JsonElement top, String fullPath) {
        JsonElement parent = top;
        String[] path = fullPath.split("/");
        for (int i = 0; i < path.length; ++i) {
            path[i] = path[i].replace("~1", "/").replace("~0", "~");
            if (i >= path.length - 1) continue;
            if (parent.isJsonObject()) {
                if ((parent = parent.getAsJsonObject().get(path[i])) != null) continue;
                throw new JsonSchemaException("Path component " + path[i] + " not found");
            }
            if (parent.isJsonArray()) {
                int index = -1;
                if (path[i].equals("-")) {
                    throw new JsonSchemaException("Path component " + path[i] + " is not allowed here");
                }
                try {
                    index = Integer.parseInt(path[i]);
                }
                catch (NumberFormatException ex) {
                    throw new JsonSchemaException("Path component " + path[i] + " is not a valid array index");
                }
                parent = parent.getAsJsonArray().get(index);
                if (parent != null) continue;
                throw new JsonSchemaException("Path component " + path[i] + " not found");
            }
            throw new JsonSchemaException("Path component " + path[i] + " is not an object or array");
        }
        return Pair.of((Object)parent, (Object)path[path.length - 1]);
    }

    public static JsonPatch parsePatch(JsonObject patch) throws JsonSchemaException {
        JsonPrimitive path = JsonUtils.getPrimitiveOrThrow("path", patch);
        JsonPrimitive op = JsonUtils.getPrimitiveOrThrow("op", patch);
        JsonElement meta = null;
        switch (op.getAsString()) {
            case "add": 
            case "replace": 
            case "test": {
                meta = JsonUtils.getOrThrow("value", patch);
                break;
            }
            case "copy": 
            case "move": {
                meta = JsonUtils.getOrThrow("from", patch);
                break;
            }
            case "remove": {
                break;
            }
            default: {
                throw new JsonSchemaException("invalid op");
            }
        }
        return new JsonPatch(JsonPatch.PatchOp.fromString(op.getAsString()), path.getAsString(), (JsonElement)(meta != null ? meta : JsonNull.INSTANCE));
    }

    public static boolean applyPatch(JsonObject working, JsonPatch p) {
        Pair<JsonElement, String> path = PatchHelper.parsePath((JsonElement)working, p.path);
        if (path == null) {
            return false;
        }
        Logger log = ThaumcraftFix.instance.getLogger();
        switch (p.op) {
            case ADD: {
                PatchHelper.patchAdd((JsonElement)path.getLeft(), (String)path.getRight(), p.meta);
                break;
            }
            case REMOVE: {
                if (PatchHelper.patchRemove((JsonElement)path.getLeft(), (String)path.getRight()) != null) break;
                log.warn("Key " + (String)path.getRight() + " was supposed to be removed, but already did not exist");
                break;
            }
            case COPY: {
                Pair<JsonElement, String> from = PatchHelper.parsePath((JsonElement)working, p.meta.getAsString());
                if (from == null) {
                    return false;
                }
                JsonElement val = PatchHelper.getValue((JsonElement)from.getLeft(), (String)from.getRight());
                if (val == null) {
                    return false;
                }
                PatchHelper.patchAdd((JsonElement)path.getLeft(), (String)path.getRight(), val);
                break;
            }
            case MOVE: {
                Pair<JsonElement, String> from = PatchHelper.parsePath((JsonElement)working, p.meta.getAsString());
                if (from == null) {
                    return false;
                }
                JsonElement val = PatchHelper.patchRemove((JsonElement)from.getLeft(), (String)from.getRight());
                if (val == null) {
                    return false;
                }
                PatchHelper.patchAdd((JsonElement)path.getLeft(), (String)path.getRight(), val);
                break;
            }
            case REPLACE: {
                if (PatchHelper.patchRemove((JsonElement)path.getLeft(), (String)path.getRight()) == null) {
                    log.warn("Key " + (String)path.getRight() + " did not exist for replace");
                }
                PatchHelper.patchAdd((JsonElement)path.getLeft(), (String)path.getRight(), p.meta);
                break;
            }
            case TEST: {
                JsonElement val = PatchHelper.patchTest((JsonElement)path.getLeft(), (String)path.getRight());
                if (val == null) {
                    log.warn("Key " + (String)path.getRight() + " did not exist for test");
                    break;
                }
                if (val.equals(p.meta)) break;
                return false;
            }
        }
        return true;
    }
}

