/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.internal.CommonInternals;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.event.research.ResearchEntryLoadEvent;
import thecodex6824.thaumcraftfix.api.event.research.ResearchLoadEvent;
import thecodex6824.thaumcraftfix.api.internal.ThaumcraftFixApiBridge;
import thecodex6824.thaumcraftfix.common.json.JsonPatch;
import thecodex6824.thaumcraftfix.common.json.JsonSchemaException;
import thecodex6824.thaumcraftfix.common.json.JsonUtils;
import thecodex6824.thaumcraftfix.common.json.PatchHelper;

@Mod.EventBusSubscriber(modid="thaumcraftfix")
public final class ResearchEventHandler {
    private static final HashMap<String, ArrayList<ArrayList<JsonPatch>>> PATCHES = new HashMap();
    private static final List<ResourceLocation> SOURCES = new ArrayList<ResourceLocation>();
    private static final Method JSON_DEEP_COPY;

    private ResearchEventHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onStartLoadResearch(ResearchLoadEvent.Pre event) {
        SOURCES.clear();
        SOURCES.addAll(ThaumcraftFixApiBridge.implementation().getFilesystemResearchEntrySources());
        for (ResourceLocation res : SOURCES) {
            CommonInternals.jsonLocs.put(res.toString(), res);
        }
        PATCHES.clear();
        Logger log = ThaumcraftFix.instance.getLogger();
        JsonParser parser = new JsonParser();
        for (ThaumcraftFixApiBridge.InternalImplementation.ResearchPatchSource source : ThaumcraftFixApiBridge.implementation().getResearchPatchSources()) {
            try {
                for (Map.Entry<String, ? extends InputStream> entry : source.open().entrySet()) {
                    try {
                        String content = IOUtils.toString((InputStream)entry.getValue(), (Charset)StandardCharsets.UTF_8);
                        JsonElement element = parser.parse(content);
                        List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                        for (JsonObject o : objects) {
                            JsonPrimitive key = JsonUtils.getPrimitiveOrThrow("key", o);
                            JsonArray ops = JsonUtils.getArrayOrThrow("ops", o);
                            ArrayList<JsonPatch> insertTo = new ArrayList<JsonPatch>();
                            for (JsonElement e : ops.getAsJsonArray()) {
                                if (!e.isJsonObject()) {
                                    throw new JsonSchemaException(e + ": Patch entry not an object");
                                }
                                insertTo.add(PatchHelper.parsePatch(e.getAsJsonObject()));
                            }
                            ArrayList<ArrayList<JsonPatch>> list = PATCHES.get(key.getAsString());
                            if (list == null) {
                                list = new ArrayList();
                                PATCHES.put(key.getAsString(), list);
                            }
                            list.add(insertTo);
                        }
                    }
                    catch (Exception ex) {
                        log.error("File {}: Error processing patch: {}", (Object)entry.getKey(), (Object)ex.getMessage());
                    }
                    finally {
                        entry.getValue().close();
                    }
                }
            }
            catch (IOException ex) {
                log.error("File {}: Error reading file(s): {}", (Object)source.getDescriptor(), (Object)ex.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onEndLoadResearch(ResearchLoadEvent.Post event) {
        PATCHES.clear();
        for (ResourceLocation res : SOURCES) {
            CommonInternals.jsonLocs.remove(res.toString());
        }
        SOURCES.clear();
    }

    private static <T extends JsonElement> T deepCopy(T element) {
        try {
            return (T)((JsonElement)JSON_DEEP_COPY.invoke(element, new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @SubscribeEvent
    public static void onLoadResearchEntry(ResearchEntryLoadEvent.Pre event) {
        boolean allowLoading = true;
        Logger log = ThaumcraftFix.instance.getLogger();
        JsonObject original = event.getResearchJson();
        JsonElement key = original.get("key");
        if (key != null && key.isJsonPrimitive()) {
            ArrayList<ArrayList<JsonPatch>> apply = PATCHES.get(key.getAsString());
            if (apply != null) {
                for (ArrayList<JsonPatch> patchList : apply) {
                    if (patchList.isEmpty()) continue;
                    boolean applyChanges = true;
                    JsonObject working = ResearchEventHandler.deepCopy(original);
                    for (JsonPatch p : patchList) {
                        try {
                            applyChanges &= PatchHelper.applyPatch(working, p);
                        }
                        catch (JsonSchemaException ex) {
                            log.warn(ex.getMessage());
                            applyChanges = false;
                        }
                        if (applyChanges) continue;
                        break;
                    }
                    if (!applyChanges) continue;
                    HashSet toRemove = new HashSet();
                    for (Map.Entry entry : original.entrySet()) {
                        toRemove.add(entry.getKey());
                    }
                    for (String s : toRemove) {
                        original.remove(s);
                    }
                    for (Map.Entry entry : working.entrySet()) {
                        original.add((String)entry.getKey(), ResearchEventHandler.deepCopy((JsonElement)entry.getValue()));
                    }
                }
                allowLoading = JsonUtils.tryGetPrimitive("key", original).isPresent();
            }
        } else {
            log.error("A research entry is missing a key (before patching), it will not be loaded. See the debug log for a json dump");
            log.debug(original.toString());
            allowLoading = false;
        }
        event.setCanceled(!allowLoading);
    }

    static {
        try {
            JSON_DEEP_COPY = JsonElement.class.getDeclaredMethod("deepCopy", new Class[0]);
            JSON_DEEP_COPY.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

