/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.world.aura.AuraHandler;
import thaumcraft.common.world.aura.AuraThread;
import thecodex6824.thaumcraftfix.api.aura.CapabilityAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.DefaultAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IAuraProcessor;
import thecodex6824.thaumcraftfix.common.aura.IListeningAuraThread;
import thecodex6824.thaumcraftfix.common.aura.RiftTriggerEvent;
import thecodex6824.thaumcraftfix.common.util.SimpleCapabilityProvider;

@Mod.EventBusSubscriber(modid="thaumcraftfix")
public class AuraEventHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            World world = event.world;
            AuraThread thread = (AuraThread)ServerEvents.auraThreads.get(world.field_73011_w.getDimension());
            if (thread instanceof IListeningAuraThread) {
                ((IListeningAuraThread)thread).notifyUpdate(world);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            World world = event.getWorld();
            AuraThread thread = (AuraThread)ServerEvents.auraThreads.get(world.field_73011_w.getDimension());
            if (thread instanceof IListeningAuraThread) {
                ((IListeningAuraThread)thread).unloadChunk(world, event.getChunk());
            }
        }
    }

    @SubscribeEvent
    public static void onRiftTrigger(RiftTriggerEvent event) {
        World world;
        BlockPos pos = event.getPosition();
        if (event.useInexactSpawning()) {
            AuraHandler.riftTrigger.put(event.getWorld().field_73011_w.getDimension(), pos);
        } else if (!ModConfig.CONFIG_MISC.wussMode && EntityUtils.getEntitiesInRange((World)(world = event.getWorld()), (BlockPos)event.getPosition(), null, EntityFluxRift.class, (double)32.0).isEmpty()) {
            EntityFluxRift rift = new EntityFluxRift(world);
            rift.setRiftSeed(world.field_73012_v.nextInt());
            rift.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            float riftSizeAndFluxCost = MathHelper.func_76129_c((float)(AuraHandler.getFlux((World)world, (BlockPos)pos) * 3.0f));
            riftSizeAndFluxCost = AuraHandler.drainFlux((World)world, (BlockPos)pos, (float)riftSizeAndFluxCost, (boolean)false);
            if (riftSizeAndFluxCost > 5.0f && world.func_72838_d((Entity)rift)) {
                rift.setRiftSize((int)riftSizeAndFluxCost);
                AxisAlignedBB researchRange = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b(32.0, 32.0, 32.0);
                for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, researchRange)) {
                    IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
                    if (knowledge.isResearchKnown("f_toomuchflux")) continue;
                    ITextComponent fluxMessage = new TextComponentTranslation("tc.fluxevent.3", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE).func_150217_b(Boolean.valueOf(true)));
                    player.func_146105_b(fluxMessage, true);
                    ThaumcraftApi.internalMethods.completeResearch(player, "f_toomuchflux");
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachCapabilitiesWorld(AttachCapabilitiesEvent<World> event) {
        for (ICapabilityProvider provider : event.getCapabilities().values()) {
            if (!provider.hasCapability(CapabilityAuraProcessor.AURA_PROCESSOR, null)) continue;
            return;
        }
        event.addCapability(new ResourceLocation("thaumcraftfix", "aura_processor"), new SimpleCapabilityProvider<IAuraProcessor>(new DefaultAuraProcessor(), CapabilityAuraProcessor.AURA_PROCESSOR));
    }
}

