/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.config;

import java.util.Arrays;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.internal.ThaumcraftFixApiBridge;
import thecodex6824.thaumcraftfix.common.network.PacketConfigSync;

@Config(modid="thaumcraftfix")
@Mod.EventBusSubscriber(modid="thaumcraftfix")
final class ThaumcraftFixConfigImpl {
    private static final String ALLOW_LIST_1 = "Determines if the list of objects specifies things that are allowed to have this feature,";
    private static final String ALLOW_LIST_2 = "instead of listing those that cannot.";
    private static final String BIOME_LIST_NAME = "biomeList";
    private static final String BIOME_LIST_LANG = "thaumcraftfix.text.config.biomeList";
    private static final String BIOME_LIST_ALLOW_NAME = "biomeListIsAllowList";
    private static final String BIOME_LIST_ALLOW_LANG = "thaumcraftfix.text.config.biomeListIsAllowList";
    private static final String BIOME_LIST_1 = "The list of biomes that will or will not have this feature enabled.";
    private static final String BIOME_LIST_2 = "Defaults to specifying the biomes to block, set BiomeListIsAllowList to true to invert behavior.";
    private static final String BIOME_LIST_3 = "Enter the biomes as namespaced IDs, i.e. thaumcraft:magical_forest";
    private static final String DIM_LIST_NAME = "dimList";
    private static final String DIM_LIST_LANG = "thaumcraftfix.text.config.dimList";
    private static final String DIM_LIST_ALLOW_NAME = "dimListIsAllowList";
    private static final String DIM_LIST_ALLOW_LANG = "thaumcraftfix.text.config.dimListIsAllowList";
    private static final String DIM_LIST_1 = "The list of dimensions that will or will not have this feature enabled.";
    private static final String DIM_LIST_2 = "Defaults to specifying the biomes to block, set DimListIsAllowList to true to invert behavior.";
    private static final String DIM_LIST_3 = "Use the registered dimension type name - if unsure, use \"/forge dimensions list\" ingame to see them all.";
    @Config.Name(value="item")
    @Config.LangKey(value="thaumcraftfix.text.config.item")
    public static ItemConfig item = new ItemConfig();
    @Config.Name(value="world")
    @Config.LangKey(value="thaumcraftfix.text.config.world")
    public static WorldConfig world = new WorldConfig();

    private ThaumcraftFixConfigImpl() {
    }

    @SubscribeEvent
    public static void onConfigSync(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("thaumcraftfix")) {
            ConfigManager.sync((String)"thaumcraftfix", (Config.Type)Config.Type.INSTANCE);
            ThaumcraftFix.instance.getConfig().bind();
            ThaumcraftFixApiBridge.implementation().reloadConfig();
            if (ThaumcraftFix.proxy.isServerRunning()) {
                ThaumcraftFix.proxy.scheduleTask(Side.SERVER, () -> {
                    PacketConfigSync packet = new PacketConfigSync(ThaumcraftFix.instance.getConfig().serializeNetwork());
                    ThaumcraftFix.instance.getNetworkHandler().sendToAll((IMessage)packet);
                });
            }
        }
    }

    public static class WorldConfig {
        @Config.Name(value="aura")
        @Config.LangKey(value="thaumcraftfix.text.config.aura")
        @Config.Comment(value={"Aura generation options"})
        public AuraConfig aura = new AuraConfig();
        @Config.Name(value="crystals")
        @Config.LangKey(value="thaumcraftfix.text.config.crystals")
        @Config.Comment(value={"Thaumcraft crystal generation options"})
        public CrystalsConfig crystals = new CrystalsConfig();
        @Config.Name(value="vegetation")
        @Config.LangKey(value="thaumcraftfix.text.config.vegetation")
        @Config.Comment(value={"Thaumcraft vegetation generation options"})
        public VegetationConfig vegetation = new VegetationConfig();

        public static class VegetationConfig
        implements Cloneable {
            @Config.Name(value="controlVegetation")
            @Config.LangKey(value="thaumcraftfix.text.config.controlVegetation")
            @Config.Comment(value={"Whether controlling Thaumcraft vegetation generation is enabled."})
            public boolean controlVegetation = false;
            @Config.Name(value="biomeListIsAllowList")
            @Config.LangKey(value="thaumcraftfix.text.config.biomeListIsAllowList")
            @Config.Comment(value={"Determines if the list of objects specifies things that are allowed to have this feature,", "instead of listing those that cannot."})
            public boolean biomeAllowList = false;
            @Config.Name(value="biomeList")
            @Config.LangKey(value="thaumcraftfix.text.config.biomeList")
            @Config.Comment(value={"The list of biomes that will or will not have this feature enabled.", "Defaults to specifying the biomes to block, set BiomeListIsAllowList to true to invert behavior.", "Enter the biomes as namespaced IDs, i.e. thaumcraft:magical_forest"})
            public String[] biomeList = new String[0];
            @Config.Name(value="dimListIsAllowList")
            @Config.LangKey(value="thaumcraftfix.text.config.dimListIsAllowList")
            @Config.Comment(value={"Determines if the list of objects specifies things that are allowed to have this feature,", "instead of listing those that cannot."})
            public boolean dimAllowList = false;
            @Config.Name(value="dimList")
            @Config.LangKey(value="thaumcraftfix.text.config.dimList")
            @Config.Comment(value={"The list of dimensions that will or will not have this feature enabled.", "Defaults to specifying the biomes to block, set DimListIsAllowList to true to invert behavior.", "Use the registered dimension type name - if unsure, use \"/forge dimensions list\" ingame to see them all."})
            public String[] dimList = new String[0];

            public VegetationConfig clone() {
                VegetationConfig config = new VegetationConfig();
                config.controlVegetation = this.controlVegetation;
                config.biomeAllowList = this.biomeAllowList;
                config.biomeList = (String[])Arrays.copyOf(this.biomeList, this.biomeList.length, String[].class);
                config.dimAllowList = this.dimAllowList;
                config.dimList = (String[])Arrays.copyOf(this.dimList, this.dimList.length, String[].class);
                return config;
            }
        }

        public static class CrystalsConfig
        implements Cloneable {
            @Config.Name(value="controlCrystals")
            @Config.LangKey(value="thaumcraftfix.text.config.controlCrystals")
            @Config.Comment(value={"Whether controlling Vis Crystal generation is enabled."})
            public boolean controlCrystals = false;
            @Config.Name(value="biomeListIsAllowList")
            @Config.LangKey(value="thaumcraftfix.text.config.biomeListIsAllowList")
            @Config.Comment(value={"Determines if the list of objects specifies things that are allowed to have this feature,", "instead of listing those that cannot."})
            public boolean biomeAllowList = false;
            @Config.Name(value="biomeList")
            @Config.LangKey(value="thaumcraftfix.text.config.biomeList")
            @Config.Comment(value={"The list of biomes that will or will not have this feature enabled.", "Defaults to specifying the biomes to block, set BiomeListIsAllowList to true to invert behavior.", "Enter the biomes as namespaced IDs, i.e. thaumcraft:magical_forest"})
            public String[] biomeList = new String[0];
            @Config.Name(value="dimListIsAllowList")
            @Config.LangKey(value="thaumcraftfix.text.config.dimListIsAllowList")
            @Config.Comment(value={"Determines if the list of objects specifies things that are allowed to have this feature,", "instead of listing those that cannot."})
            public boolean dimAllowList = false;
            @Config.Name(value="dimList")
            @Config.LangKey(value="thaumcraftfix.text.config.dimList")
            @Config.Comment(value={"The list of dimensions that will or will not have this feature enabled.", "Defaults to specifying the biomes to block, set DimListIsAllowList to true to invert behavior.", "Use the registered dimension type name - if unsure, use \"/forge dimensions list\" ingame to see them all."})
            public String[] dimList = new String[0];

            public CrystalsConfig clone() {
                CrystalsConfig config = new CrystalsConfig();
                config.controlCrystals = this.controlCrystals;
                config.biomeAllowList = this.biomeAllowList;
                config.biomeList = (String[])Arrays.copyOf(this.biomeList, this.biomeList.length, String[].class);
                config.dimAllowList = this.dimAllowList;
                config.dimList = (String[])Arrays.copyOf(this.dimList, this.dimList.length, String[].class);
                return config;
            }
        }

        public static class AuraConfig
        implements Cloneable {
            @Config.Name(value="controlAura")
            @Config.LangKey(value="thaumcraftfix.text.config.controlAura")
            @Config.Comment(value={"Whether controlling Aura generation is enabled."})
            public boolean controlAura = false;
            @Config.Name(value="biomeListIsAllowList")
            @Config.LangKey(value="thaumcraftfix.text.config.biomeListIsAllowList")
            @Config.Comment(value={"Determines if the list of objects specifies things that are allowed to have this feature,", "instead of listing those that cannot."})
            public boolean biomeAllowList = false;
            @Config.Name(value="biomeList")
            @Config.LangKey(value="thaumcraftfix.text.config.biomeList")
            @Config.Comment(value={"The list of biomes that will or will not have this feature enabled.", "Defaults to specifying the biomes to block, set BiomeListIsAllowList to true to invert behavior.", "Enter the biomes as namespaced IDs, i.e. thaumcraft:magical_forest"})
            public String[] biomeList = new String[0];
            @Config.Name(value="dimListIsAllowList")
            @Config.LangKey(value="thaumcraftfix.text.config.dimListIsAllowList")
            @Config.Comment(value={"Determines if the list of objects specifies things that are allowed to have this feature,", "instead of listing those that cannot."})
            public boolean dimAllowList = false;
            @Config.Name(value="dimList")
            @Config.LangKey(value="thaumcraftfix.text.config.dimList")
            @Config.Comment(value={"The list of dimensions that will or will not have this feature enabled.", "Defaults to specifying the biomes to block, set DimListIsAllowList to true to invert behavior.", "Use the registered dimension type name - if unsure, use \"/forge dimensions list\" ingame to see them all."})
            public String[] dimList = new String[0];

            public AuraConfig clone() {
                AuraConfig config = new AuraConfig();
                config.controlAura = this.controlAura;
                config.biomeAllowList = this.biomeAllowList;
                config.biomeList = (String[])Arrays.copyOf(this.biomeList, this.biomeList.length, String[].class);
                config.dimAllowList = this.dimAllowList;
                config.dimList = (String[])Arrays.copyOf(this.dimList, this.dimList.length, String[].class);
                return config;
            }
        }
    }

    public static class ItemConfig {
        @Config.Name(value="primordialPearlDamageFix")
        @Config.LangKey(value="thaumcraftfix.text.config.primordialPearlDamageFix")
        @Config.Comment(value={"Enables/disables the Primordial Pearl damage value fix.", "This fix will prevent vanilla and other mods from repairing Primordial Pearls,", "but may cause compatibility issues with existing Thaumcraft addons."})
        public boolean primordialPearlDamageFix = true;
    }
}

