/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.aura;

import java.util.concurrent.Semaphore;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.Thaumcraft;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.world.aura.AuraHandler;
import thaumcraft.common.world.aura.AuraThread;
import thaumcraft.common.world.aura.AuraWorld;
import thecodex6824.thaumcraftfix.api.aura.IAuraChunk;
import thecodex6824.thaumcraftfix.api.aura.IAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IAuraWorld;
import thecodex6824.thaumcraftfix.common.aura.IListeningAuraThread;

public class GenericAuraThread
extends AuraThread
implements IListeningAuraThread {
    private final IAuraProcessor processor;
    private final Semaphore waitSem = new Semaphore(0);
    private volatile boolean stop;

    public GenericAuraThread(int dim, IAuraProcessor worldProcessor) {
        super(dim);
        this.processor = worldProcessor;
    }

    @Override
    public void notifyUpdate(World world) {
        this.processor.gameTick(world);
        this.waitSem.release();
    }

    @Override
    public void unloadChunk(World world, Chunk chunk) {
        IAuraChunk aura;
        AuraWorld auraWorld = AuraHandler.getAuraWorld((int)this.dim);
        if (auraWorld instanceof IAuraWorld && (aura = ((IAuraWorld)auraWorld).getAuraChunk(chunk.field_76635_g, chunk.field_76647_h)) != null && aura.isModified()) {
            chunk.func_76630_e();
        }
    }

    public void run() {
        Thaumcraft.log.info("Starting aura thread for dim {}", (Object)this.dim);
        while (!this.stop) {
            try {
                this.waitSem.acquire();
            }
            catch (InterruptedException ex) {
                this.stop = true;
            }
            if (this.stop) break;
            AuraWorld auraWorld = AuraHandler.getAuraWorld((int)this.dim);
            if (auraWorld instanceof IAuraWorld) {
                this.processor.auraTick((IAuraWorld)auraWorld);
                continue;
            }
            Thaumcraft.log.info("Aura for dim {} was unloaded, stopping aura thread", (Object)this.dim);
            this.stop();
            break;
        }
        Thaumcraft.log.info("Stopping aura thread for dim {}", (Object)this.dim);
        ServerEvents.auraThreads.remove(this.dim);
    }

    public void stop() {
        this.stop = true;
        this.waitSem.release();
    }
}

