/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Textifier;
import thecodex6824.coremodlib.FieldAccessType;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.InstructionMatcher;
import thecodex6824.coremodlib.LocalVariableDefinition;
import thecodex6824.coremodlib.MatchResult;
import thecodex6824.coremodlib.MethodDefinition;

class PrefabMatchers {
    PrefabMatchers() {
    }

    public static class StringLdcMatch
    implements InstructionMatcher {
        private final String str;

        public StringLdcMatch(String constant) {
            this.str = constant;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof LdcInsnNode) {
                ret = this.str.equals(((LdcInsnNode)node).cst);
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is an LDC node loading the string constant \"%s\"", this.str);
        }
    }

    public static class TypeInsnMatch
    implements InstructionMatcher {
        private final int opcode;
        private final Type desc;

        public TypeInsnMatch(int opcode, Type castDesc) {
            this.opcode = opcode;
            this.desc = castDesc;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node.getOpcode() == this.opcode && node instanceof TypeInsnNode) {
                TypeInsnNode typeNode = (TypeInsnNode)node;
                ret = typeNode.desc.equals(this.desc.getInternalName());
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node has an opcode of %s and is casting to type %s", Textifier.OPCODES[this.opcode], this.desc.getInternalName());
        }
    }

    public static class MethodReturnTypeMatch
    implements InstructionMatcher {
        private final Type returnType;

        public MethodReturnTypeMatch(Type type) {
            this.returnType = type;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof MethodInsnNode) {
                MethodInsnNode methodInsn = (MethodInsnNode)node;
                ret = Type.getMethodType((String)methodInsn.desc).getReturnType().equals((Object)this.returnType);
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is calling a method returning type %s", this.returnType.getInternalName());
        }
    }

    public static class MethodCallMatch
    implements InstructionMatcher {
        private final MethodDefinition methodDef;

        public MethodCallMatch(MethodDefinition method) {
            this.methodDef = method;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof MethodInsnNode) {
                MethodInsnNode methodInsn = (MethodInsnNode)node;
                ret = methodInsn.owner.equals(this.methodDef.declaringClass()) && methodInsn.name.equals(this.methodDef.name()) && methodInsn.desc.equals(this.methodDef.desc()) && methodInsn.itf == this.methodDef.declaringClassIsInterface();
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is calling method %s", this.methodDef.toString());
        }
    }

    public static class FieldTypeMatch
    implements InstructionMatcher {
        private final Type fieldType;

        public FieldTypeMatch(Type type) {
            this.fieldType = type;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof FieldInsnNode) {
                FieldInsnNode field = (FieldInsnNode)node;
                ret = field.desc.equals(this.fieldType.getDescriptor());
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is accessing field any field of type %s", this.fieldType.getClassName());
        }
    }

    public static class FieldMatch
    implements InstructionMatcher {
        private final FieldDefinition fieldDef;
        private final FieldAccessType type;

        public FieldMatch(FieldDefinition field, FieldAccessType access) {
            this.fieldDef = field;
            this.type = access;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof FieldInsnNode) {
                FieldInsnNode field = (FieldInsnNode)node;
                ret = field.name.equals(this.fieldDef.name()) && field.desc.equals(this.fieldDef.desc()) && this.type.matches(field.getOpcode());
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is accessing field %s", this.fieldDef.toString());
        }
    }

    public static class LocalVariableMatchByDefinition
    implements InstructionMatcher {
        private final LocalVariableDefinition local;

        public LocalVariableMatchByDefinition(LocalVariableDefinition localDef) {
            this.local = localDef;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof VarInsnNode) {
                LocalVariableNode var = method.localVariables.stream().filter(v -> v.desc.equals(this.local.desc()) && v.name.equals(this.local.name())).findAny().orElse(null);
                ret = var != null && ((VarInsnNode)node).var == var.index;
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is accessing local variable %s", this.local.toString());
        }
    }

    public static class LocalVariableMatchByIndex
    implements InstructionMatcher {
        private final int index;

        public LocalVariableMatchByIndex(int varIndex) {
            this.index = varIndex;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            boolean ret = false;
            if (node instanceof VarInsnNode) {
                ret = ((VarInsnNode)node).var == this.index;
            }
            return ret ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is accessing local variable at index %d", this.index);
        }
    }

    public static class ClassMatch
    implements InstructionMatcher {
        private final Class<? extends AbstractInsnNode> cls;

        public ClassMatch(Class<? extends AbstractInsnNode> nodeClass) {
            this.cls = nodeClass;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            return this.cls.isInstance(node) ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node is an instance of %s", this.cls.getTypeName());
        }
    }

    public static class OpcodeMatch
    implements InstructionMatcher {
        private final int opcode;

        public OpcodeMatch(int opcode) {
            this.opcode = opcode;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            return node.getOpcode() == this.opcode ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return String.format("Node has an opcode of %s", Textifier.OPCODES[this.opcode]);
        }
    }

    public static class ConsecutiveMatch
    implements InstructionMatcher {
        private final ImmutableList<InstructionMatcher> matchers;

        public ConsecutiveMatch(List<InstructionMatcher> matchers) {
            this.matchers = ImmutableList.copyOf(matchers);
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            AbstractInsnNode current = node;
            for (InstructionMatcher matcher : this.matchers) {
                if (current == null || !matcher.matches(method, current).matched()) {
                    return MatchResult.noMatch();
                }
                current = current.getNext();
            }
            return MatchResult.matchNodeRange(node, current.getPrevious());
        }

        public String toString() {
            StringJoiner output = new StringJoiner(System.lineSeparator());
            for (InstructionMatcher matcher : this.matchers) {
                output.add("\t" + matcher.toString());
            }
            return String.format("Nodes must consecutively match:%n%s", output.toString());
        }
    }

    public static class GenericMatch
    implements InstructionMatcher {
        private final Function<AbstractInsnNode, Boolean> matcher;

        public GenericMatch(Function<AbstractInsnNode, Boolean> matcher) {
            this.matcher = matcher;
        }

        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            return this.matcher.apply(node) != false ? MatchResult.matchSingleNode(node) : MatchResult.noMatch();
        }

        public String toString() {
            return "Generic node, no details :(";
        }
    }

    public static class AlwaysMatch
    implements InstructionMatcher {
        @Override
        public MatchResult matches(MethodNode method, AbstractInsnNode node) {
            return MatchResult.matchSingleNode(node);
        }

        public String toString() {
            return "Always matches any and every input node";
        }
    }
}

