/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import thecodex6824.coremodlib.ASMUtil;
import thecodex6824.coremodlib.FieldAccessType;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.InstructionMatcher;
import thecodex6824.coremodlib.LocalVariableDefinition;
import thecodex6824.coremodlib.MatchAction;
import thecodex6824.coremodlib.MatchDetails;
import thecodex6824.coremodlib.MatchTransformer;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.coremodlib.PrefabMatchActions;
import thecodex6824.coremodlib.PrefabMatchTransformers;
import thecodex6824.coremodlib.PrefabMatchers;

public class PatchBuilders {

    public static class TransformerBuilder
    extends MatchBuilder<TransformerBuilder> {
        private MethodDefinition method;
        private Map<InstructionMatcher, MatchEntry> matchToActions;

        public TransformerBuilder(MethodDefinition targetMethod) {
            this.method = targetMethod;
            this.matchToActions = new IdentityHashMap<InstructionMatcher, MatchEntry>();
        }

        private List<MatchTransformer> getTransformerList() {
            if (this.matchers.isEmpty()) {
                this.matchers.add(new PrefabMatchers.AlwaysMatch());
            }
            return this.matchToActions.computeIfAbsent(this.matchers.get((int)(this.matchers.size() - 1)), (Function<InstructionMatcher, MatchEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTransformerList$0(thecodex6824.coremodlib.InstructionMatcher ), (Lthecodex6824/coremodlib/InstructionMatcher;)Lthecodex6824/coremodlib/PatchBuilders$TransformerBuilder$MatchEntry;)()).transformers;
        }

        private List<MatchAction> getActionList() {
            if (this.matchers.isEmpty()) {
                this.matchers.add(new PrefabMatchers.AlwaysMatch());
            }
            return this.matchToActions.computeIfAbsent(this.matchers.get((int)(this.matchers.size() - 1)), (Function<InstructionMatcher, MatchEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getActionList$1(thecodex6824.coremodlib.InstructionMatcher ), (Lthecodex6824/coremodlib/InstructionMatcher;)Lthecodex6824/coremodlib/PatchBuilders$TransformerBuilder$MatchEntry;)()).actions;
        }

        public ConsecutiveMatchBuilder findConsecutive() {
            return new ConsecutiveMatchBuilder(this);
        }

        public TransformerBuilder insertInstructionsBefore(AbstractInsnNode ... toInsert) {
            return this.insertInstructionsBefore(ASMUtil.arrayToInsnList(toInsert));
        }

        public TransformerBuilder insertInstructionsBefore(InsnList toInsert) {
            this.getActionList().add(new PrefabMatchActions.InsertInstructionsBeforeMatch(toInsert));
            return this;
        }

        public TransformerBuilder insertInstructionsAfter(AbstractInsnNode ... toInsert) {
            return this.insertInstructionsAfter(ASMUtil.arrayToInsnList(toInsert));
        }

        public TransformerBuilder insertInstructionsAfter(InsnList toInsert) {
            this.getActionList().add(new PrefabMatchActions.InsertInstructionsAfterMatch(toInsert));
            return this;
        }

        public SurroundingActionBuilder insertInstructionsSurrounding() {
            return new SurroundingActionBuilder(this);
        }

        public TransformerBuilder insertInstructions(BiFunction<MethodNode, List<? extends MatchDetails>, Collection<AbstractInsnNode>> inserter) {
            this.getActionList().add(new PrefabMatchActions.GenericAction(inserter));
            return this;
        }

        public TransformerBuilder matchLastNodeOnly() {
            this.getTransformerList().add(new PrefabMatchTransformers.LastNodeOnly());
            return this;
        }

        public TransformerBuilder combineLastTwoMatches() {
            this.getTransformerList().add(new PrefabMatchTransformers.MakeMatchRange());
            return this;
        }

        public PatchStateMachine build() {
            ImmutableList.Builder nodeBuilder = ImmutableList.builder();
            for (InstructionMatcher matcher : this.matchers) {
                MatchEntry entry = this.matchToActions.getOrDefault(matcher, new MatchEntry());
                nodeBuilder.add((Object)new PatchStateMachine.InstructionStateMachineNode(matcher, entry.transformers, entry.actions));
            }
            return new PatchStateMachine(this.method, (ImmutableList<PatchStateMachine.InstructionStateMachineNode>)nodeBuilder.build());
        }

        private static /* synthetic */ MatchEntry lambda$getActionList$1(InstructionMatcher m) {
            return new MatchEntry();
        }

        private static /* synthetic */ MatchEntry lambda$getTransformerList$0(InstructionMatcher m) {
            return new MatchEntry();
        }

        private static class MatchEntry {
            public final List<MatchTransformer> transformers = new ArrayList<MatchTransformer>();
            public final List<MatchAction> actions = new ArrayList<MatchAction>();

            private MatchEntry() {
            }
        }
    }

    public static class SurroundingActionBuilder {
        private TransformerBuilder parent;
        private InsnList beforeList;
        private InsnList afterList;

        protected SurroundingActionBuilder(TransformerBuilder builder) {
            this.parent = builder;
        }

        public SurroundingActionBuilder before(AbstractInsnNode ... toInsert) {
            return this.before(ASMUtil.arrayToInsnList(toInsert));
        }

        public SurroundingActionBuilder before(InsnList toInsert) {
            this.beforeList = toInsert;
            return this;
        }

        public SurroundingActionBuilder after(AbstractInsnNode ... toInsert) {
            return this.after(ASMUtil.arrayToInsnList(toInsert));
        }

        public SurroundingActionBuilder after(InsnList toInsert) {
            this.afterList = toInsert;
            return this;
        }

        public TransformerBuilder endAction() {
            if (this.beforeList == null || this.afterList == null) {
                throw new IllegalStateException("Cannot build surrounding action without calling before() and after()");
            }
            this.parent.getActionList().add(new PrefabMatchActions.InsertInstructionsSurroundingMatch(this.beforeList, this.afterList));
            return this.parent;
        }
    }

    public static class ConsecutiveMatchBuilder
    extends MatchBuilder<ConsecutiveMatchBuilder> {
        private TransformerBuilder parent;

        protected ConsecutiveMatchBuilder(TransformerBuilder builder) {
            this.parent = builder;
        }

        public TransformerBuilder endConsecutive() {
            this.parent.matchers.add(new PrefabMatchers.ConsecutiveMatch(this.matchers));
            return this.parent;
        }
    }

    private static abstract class MatchBuilder<T extends MatchBuilder<?>> {
        protected ArrayList<InstructionMatcher> matchers = new ArrayList();

        public T findAny() {
            this.matchers.add(new PrefabMatchers.AlwaysMatch());
            return (T)this;
        }

        public T findNext(Function<AbstractInsnNode, Boolean> matcher) {
            this.matchers.add(new PrefabMatchers.GenericMatch(matcher));
            return (T)this;
        }

        public T findNextOpcode(int opcode) {
            this.matchers.add(new PrefabMatchers.OpcodeMatch(opcode));
            return (T)this;
        }

        public T findNextInstructionType(Class<? extends AbstractInsnNode> clazz) {
            this.matchers.add(new PrefabMatchers.ClassMatch(clazz));
            return (T)this;
        }

        public T findNextLocalAccess(int index) {
            this.matchers.add(new PrefabMatchers.LocalVariableMatchByIndex(index));
            return (T)this;
        }

        public T findNextLocalAccess(LocalVariableDefinition local) {
            this.matchers.add(new PrefabMatchers.LocalVariableMatchByDefinition(local));
            return (T)this;
        }

        public T findNextFieldAccess(FieldDefinition fieldDef) {
            return this.findNextFieldAccess(fieldDef, FieldAccessType.ALL);
        }

        public T findNextFieldAccess(FieldDefinition fieldDef, FieldAccessType access) {
            this.matchers.add(new PrefabMatchers.FieldMatch(fieldDef, access));
            return (T)this;
        }

        public T findNextFieldAccessOfType(Type fieldType) {
            this.matchers.add(new PrefabMatchers.FieldTypeMatch(fieldType));
            return (T)this;
        }

        public T findNextMethodCall(MethodDefinition methodDef) {
            this.matchers.add(new PrefabMatchers.MethodCallMatch(methodDef));
            return (T)this;
        }

        public T findNextMethodCallReturningType(Type returnType) {
            this.matchers.add(new PrefabMatchers.MethodReturnTypeMatch(returnType));
            return (T)this;
        }

        public T findNextCheckCast(Type castDesc) {
            this.matchers.add(new PrefabMatchers.TypeInsnMatch(192, castDesc));
            return (T)this;
        }

        public T findNextInstanceOf(Type castDesc) {
            this.matchers.add(new PrefabMatchers.TypeInsnMatch(193, castDesc));
            return (T)this;
        }

        public T findNextStringConstant(String str) {
            this.matchers.add(new PrefabMatchers.StringLdcMatch(str));
            return (T)this;
        }

        public T findNextNewObject(Type newType) {
            this.matchers.add(new PrefabMatchers.TypeInsnMatch(187, newType));
            return (T)this;
        }
    }
}

