/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.network.MachineInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketReturnRfInRange
implements IMessage {
    private Map<BlockPos, MachineInfo> levels;
    public static Map<BlockPos, MachineInfo> clientLevels;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.levels = new HashMap<BlockPos, MachineInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = NetworkTools.readPos((ByteBuf)buf);
            long e = buf.readLong();
            long m = buf.readLong();
            Long usage = null;
            if (buf.readBoolean()) {
                usage = buf.readLong();
            }
            this.levels.put(pos, new MachineInfo(e, m, usage));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.levels.size());
        for (Map.Entry<BlockPos, MachineInfo> entry : this.levels.entrySet()) {
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)entry.getKey());
            MachineInfo info = entry.getValue();
            buf.writeLong(info.getEnergy());
            buf.writeLong(info.getMaxEnergy());
            if (info.getEnergyPerTick() != null) {
                buf.writeBoolean(true);
                buf.writeLong(info.getEnergyPerTick().longValue());
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public Map<BlockPos, MachineInfo> getLevels() {
        return this.levels;
    }

    public PacketReturnRfInRange() {
    }

    public PacketReturnRfInRange(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnRfInRange(Map<BlockPos, MachineInfo> levels) {
        this.levels = levels;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            clientLevels = this.levels;
        });
        ctx.setPacketHandled(true);
    }
}

