/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.creativeonly;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.items.creativeonly.DelightingInfoHelper;
import mcjty.rftools.items.creativeonly.PacketDelightingInfoReady;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetDelightingInfo
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetDelightingInfo() {
    }

    public PacketGetDelightingInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetDelightingInfo(BlockPos pos) {
        this.pos = pos;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            World world = player.func_130014_f_();
            ArrayList<String> blockClasses = new ArrayList<String>();
            ArrayList<String> teClasses = new ArrayList<String>();
            HashMap<String, DelightingInfoHelper.NBTDescription> nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>();
            int metadata = DelightingInfoHelper.fillDelightingData(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), world, blockClasses, teClasses, nbtData);
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketDelightingInfoReady(blockClasses, teClasses, nbtData, metadata), ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

