/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import net.minecraft.util.math.BlockPos;

public class TeleportDestination {
    private final BlockPos coordinate;
    private final int dimension;
    private String name = "";

    public TeleportDestination(ByteBuf buf) {
        int cx = buf.readInt();
        int cy = buf.readInt();
        int cz = buf.readInt();
        this.coordinate = cx == -1 && cy == -1 && cz == -1 ? null : new BlockPos(cx, cy, cz);
        this.dimension = buf.readInt();
        this.setName(NetworkTools.readString((ByteBuf)buf));
    }

    public TeleportDestination(BlockPos coordinate, int dimension) {
        this.coordinate = coordinate;
        this.dimension = dimension;
    }

    public boolean isValid() {
        return this.coordinate != null;
    }

    public void toBytes(ByteBuf buf) {
        if (this.coordinate == null) {
            buf.writeInt(-1);
            buf.writeInt(-1);
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.coordinate.func_177958_n());
            buf.writeInt(this.coordinate.func_177956_o());
            buf.writeInt(this.coordinate.func_177952_p());
        }
        buf.writeInt(this.dimension);
        NetworkTools.writeString((ByteBuf)buf, (String)this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeleportDestination that = (TeleportDestination)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.coordinate != null ? !this.coordinate.equals((Object)that.coordinate) : that.coordinate != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + this.dimension;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

