/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.security.SecuritySetup;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SecurityManagerTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_SETCHANNELNAME = "security.setChannelName";
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    public static final String CMD_SETMODE = "security.setMode";
    public static final Key<Boolean> PARAM_WHITELIST = new Key("whitelist", Type.BOOLEAN);
    public static final String CMD_ADDPLAYER = "security.addPlayer";
    public static final String CMD_DELPLAYER = "security.delPlayer";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final int SLOT_CARD = 0;
    public static final int SLOT_LINKER = 1;
    public static final int SLOT_BUFFER = 2;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)SecuritySetup.securityCardItem)}), "container", 0, 10, 7, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)SecuritySetup.securityCardItem)}), "container", 1, 42, 7, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)SecuritySetup.securityCardItem)}), "container", 2, 10, 124, 3, 18, 4, 18);
            this.layoutPlayerInventorySlots(74, 124);
        }
    };
    public static final int BUFFER_SIZE = 12;
    public static final int SLOT_PLAYERINV = 14;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 14);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private NBTTagCompound getOrCreateNBT(ItemStack cardStack) {
        NBTTagCompound tagCompound = cardStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            cardStack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private void updateCard(ItemStack cardStack) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (cardStack.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = this.getOrCreateNBT(cardStack);
        if (!tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = securityChannels.newChannel();
            tagCompound.func_74768_a("channel", id);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void updateLinkedCard() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack masterCard = this.inventoryHelper.getStackInSlot(0);
        if (masterCard.func_190926_b()) {
            return;
        }
        ItemStack linkerCard = this.inventoryHelper.getStackInSlot(1);
        if (linkerCard.func_190926_b()) {
            return;
        }
        NBTTagCompound masterNBT = masterCard.func_77978_p();
        if (masterNBT == null) {
            return;
        }
        NBTTagCompound linkerNBT = this.getOrCreateNBT(linkerCard);
        linkerNBT.func_74768_a("channel", masterNBT.func_74762_e("channel"));
        this.markDirtyClient();
    }

    private void addPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.addPlayer(player);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void delPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.delPlayer(player);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void setWhiteListMode(boolean whitelist) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setWhitelist(whitelist);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void setChannelName(String name) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setName(name);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private NBTTagCompound getCardInfo() {
        ItemStack cardStack = this.inventoryHelper.getStackInSlot(0);
        if (cardStack.func_190926_b()) {
            return null;
        }
        return this.getOrCreateNBT(cardStack);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index == 0) {
            this.updateCard(stack);
            this.updateLinkedCard();
        } else if (index == 1) {
            this.updateLinkedCard();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return ((Object)((Object)SecuritySetup.securityCardItem)).equals(stack.func_77973_b());
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETCHANNELNAME.equals(command)) {
            this.setChannelName((String)params.get(PARAM_NAME));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setWhiteListMode((Boolean)params.get(PARAM_WHITELIST));
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        return false;
    }
}

