/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.TickOrderHandler;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class PearlInjectorTileEntity
extends GenericTileEntity
implements DefaultSidedInventory,
ITickable,
TickOrderHandler.ICheckStateServer {
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/pearl_injector.gui"));
    public static final int BUFFER_SIZE = 18;
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_PLAYERINV = 18;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 18);
    private boolean prevIn = false;
    private int[] accessibleSlots;

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public EndergenicTileEntity findEndergenicTileEntity() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing k = OrientationTools.getOrientation((IBlockState)state);
        EndergenicTileEntity te = this.getEndergenicGeneratorAt(k.func_176734_d());
        if (te != null) {
            return te;
        }
        return this.getEndergenicGeneratorAt(EnumFacing.UP);
    }

    private EndergenicTileEntity getEndergenicGeneratorAt(EnumFacing k) {
        BlockPos o = this.func_174877_v().func_177972_a(k);
        TileEntity te = this.func_145831_w().func_175625_s(o);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            TickOrderHandler.queuePearlInjector(this);
        }
    }

    @Override
    public void checkStateServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        if (this.prevIn == this.powerLevel > 0) {
            return;
        }
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.injectPearl();
        }
        this.func_70296_d();
    }

    @Override
    public int getDimension() {
        return this.field_145850_b.field_73011_w.getDimension();
    }

    private boolean takePearl() {
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            if (stack.func_190926_b() || !Items.field_151079_bi.equals(stack.func_77973_b()) || stack.func_190916_E() <= 0) continue;
            this.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    public void injectPearl() {
        EndergenicTileEntity endergen = this.findEndergenicTileEntity();
        if (endergen != null) {
            if (!this.takePearl()) {
                return;
            }
            int mode = endergen.getChargingMode();
            if (mode != -1) {
                endergen.firePearlFromInjector();
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return Items.field_151079_bi.equals(stack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.accessibleSlots == null) {
            this.accessibleSlots = new int[18];
            for (int i = 0; i < 18; ++i) {
                this.accessibleSlots[i] = i;
            }
        }
        return this.accessibleSlots;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }
}

