/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.apiimpl;

import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftools.api.teleportation.ITeleportationManager;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TeleportationManager
implements ITeleportationManager {
    @Override
    public String getReceiverName(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == TeleporterSetup.matterReceiverBlock) {
            MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.func_175625_s(pos);
            return te.getName();
        }
        return null;
    }

    @Override
    public boolean createReceiver(World world, BlockPos pos, String name, int power) {
        world.func_180501_a(pos, TeleporterSetup.matterReceiverBlock.func_176223_P(), 2);
        MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.func_175625_s(pos);
        if (power == -1) {
            te.modifyEnergyStored(TeleportConfiguration.RECEIVER_MAXENERGY.get());
        } else {
            te.modifyEnergyStored(Math.min(power, TeleportConfiguration.RECEIVER_MAXENERGY.get()));
        }
        te.setName(name);
        te.func_70296_d();
        this.registerReceiver(world, pos, name);
        return true;
    }

    private void registerReceiver(World world, BlockPos pos, String name) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        GlobalCoordinate gc = new GlobalCoordinate(pos, world.field_73011_w.getDimension());
        TeleportDestination destination = destinations.addDestination(gc);
        destination.setName(name);
        destinations.save();
    }

    @Override
    public void teleportPlayer(EntityPlayer player, int dimension, BlockPos location) {
        TeleportationTools.teleportToDimension((EntityPlayer)player, (int)dimension, (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p());
    }

    @Override
    public void removeReceiverDestinations(World world, int dim) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        destinations.removeDestinationsInDimension(dim);
        destinations.save();
    }
}

