/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.intermod;

import exterminatorjeff.undergroundbiomes.api.common.IUBOreConfig;
import java.util.ArrayList;

public class UBOreConfig
implements IUBOreConfig {
    private final String internalOreName;
    private final int meta;
    private final String overlay;
    private final String color;
    private final Integer lightValue;
    private final boolean alphaOverlay;
    private final ArrayList<String> oreDirectories;

    public UBOreConfig(String internalOreName, int meta, String overlay, ArrayList<String> oreDirectories, String color) {
        this.internalOreName = internalOreName;
        this.meta = meta;
        this.overlay = overlay;
        this.oreDirectories = oreDirectories;
        this.color = color;
        this.lightValue = -1;
        this.alphaOverlay = false;
    }

    public UBOreConfig(String internalOreName, int meta, String overlay, ArrayList<String> oreDirectories) {
        this(internalOreName, meta, overlay, oreDirectories, null);
    }

    public UBOreConfig(String internalOreName, int meta, String overlay) {
        this(internalOreName, meta, overlay, new ArrayList<String>());
    }

    public UBOreConfig(String internalOreName, int meta, String overlay, String color) {
        this(internalOreName, meta, overlay, new ArrayList<String>(), color);
    }

    public UBOreConfig(String ore_name, String overlay) {
        this(ore_name, -1, overlay, new ArrayList<String>());
    }

    public UBOreConfig(String ore_name, String overlay, String color) {
        this(ore_name, -1, overlay, new ArrayList<String>(), color);
    }

    public UBOreConfig(String ore_name, String overlay, ArrayList<String> oreDirectories) {
        this(ore_name, -1, overlay, oreDirectories);
    }

    @Override
    public String toKey() {
        return this.internalOreName + ":" + this.meta;
    }

    @Override
    public String getInternalOreName() {
        return this.internalOreName;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public String getOverlay() {
        return this.overlay;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public ArrayList<String> getOreDirectories() {
        if (this.oreDirectories == null) {
            return new ArrayList<String>();
        }
        return this.oreDirectories;
    }

    @Override
    public int getLightValue() {
        if (this.lightValue == null) {
            return -1;
        }
        return this.lightValue;
    }

    @Override
    public boolean hasAlphaOverlay() {
        return this.alphaOverlay;
    }
}

