/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.intermod;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.DropSource;
import exterminatorjeff.undergroundbiomes.api.common.UBDropsRegistry;
import exterminatorjeff.undergroundbiomes.api.enums.FossilVariant;
import exterminatorjeff.undergroundbiomes.api.enums.SedimentaryVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public enum DropsRegistry implements UBDropsRegistry
{
    INSTANCE;

    private final Map<Block, List<DropSource>> dropsSources = new HashMap<Block, List<DropSource>>();

    private void addSourceFor(Block stone, DropSource source) {
        if (!this.dropsSources.containsKey(stone)) {
            this.dropsSources.put(stone, new ArrayList());
        }
        this.dropsSources.get(stone).add(source);
    }

    private List<DropSource> getSourcesFor(Block stone) {
        List<DropSource> sources = this.dropsSources.get(stone);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    @Override
    public void registerDropSourceFor(Block stone, DropSource source) {
        this.addSourceFor(stone, source);
    }

    public void init() {
        this.addSourceFor(API.IGNEOUS_STONE.getBlock(), (drops, world, pos, state, fortune) -> {
            if (pos.func_177956_o() <= 32 && world.field_73012_v.nextInt(100) <= fortune) {
                drops.clear();
                drops.add(new ItemStack(Items.field_151074_bl));
            }
        });
        this.addSourceFor(API.METAMORPHIC_STONE.getBlock(), (drops, world, pos, state, fortune) -> {
            if (world.field_73012_v.nextInt(100) <= fortune) {
                if (pos.func_177956_o() <= 16) {
                    drops.clear();
                    drops.add(new ItemStack(Items.field_151137_ax));
                } else if (pos.func_177956_o() <= 32) {
                    drops.clear();
                    drops.add(new ItemStack(Items.field_151100_aR, 1, 4));
                }
            }
        });
        this.addSourceFor(API.SEDIMENTARY_STONE.getBlock(), (drops, world, pos, state, fortune) -> {
            if (world.field_73012_v.nextInt(100) <= fortune) {
                switch ((SedimentaryVariant)state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY)) {
                    case CHALK: {
                        drops.clear();
                        drops.add(new ItemStack(API.FOSSIL_PIECE.getItem(), 1, world.field_73012_v.nextInt(FossilVariant.NB_VARIANTS)));
                        break;
                    }
                    case DOLOMITE: 
                    case LIGNITE: 
                    case LIMESTONE: {
                        drops.clear();
                        drops.add(new ItemStack(API.FOSSIL_PIECE.getItem(), 1, world.field_73012_v.nextInt(FossilVariant.NB_VARIANTS)));
                        break;
                    }
                    case SILTSTONE: {
                        drops.clear();
                        drops.add(new ItemStack(API.FOSSIL_PIECE.getItem(), 1, world.field_73012_v.nextInt(FossilVariant.NB_VARIANTS)));
                        break;
                    }
                    case SHALE: {
                        drops.clear();
                        drops.add(new ItemStack(Items.field_151119_aD));
                        break;
                    }
                    case CHERT: {
                        drops.clear();
                        drops.add(new ItemStack(Items.field_151145_ak));
                        break;
                    }
                }
            }
        });
    }

    public void addDrops(List<ItemStack> drops, Block stone, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        for (DropSource source : this.getSourcesFor(stone)) {
            source.addDrops(drops, (World)world, pos, state, fortune);
        }
    }
}

