/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import edgarallen.soundmuffler.SuperSoundMuffler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(modid="baubles", iface="baubles.api.IBauble")
public class ItemSoundMufflerBauble
extends Item
implements IBauble {
    public static final String NAME = "sound_muffler_bauble";

    public ItemSoundMufflerBauble() {
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_185043_a(new ResourceLocation("disabled"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemSoundMufflerBauble.this.isDisabled(stack) ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af()) {
            this.toggleDisabled(playerIn, stack);
        } else {
            playerIn.openGui((Object)SuperSoundMuffler.instance, 1, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.sound_muffler_bauble.tooltip.header", (Object[])new Object[0]));
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            boolean showWhiteListTooltip = !compound.func_74764_b("whiteList") || compound.func_74767_n("whiteList");
            String key = showWhiteListTooltip ? "item.sound_muffler.tooltip.mode.white_list" : "item.sound_muffler.tooltip.mode.black_list";
            tooltip.add(I18n.func_135052_a((String)key, (Object[])new Object[0]));
            if (compound.func_74764_b("sounds")) {
                NBTTagList tagList = compound.func_150295_c("sounds", 10);
                int count = tagList.func_74745_c();
                tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{count}));
                if (GuiScreen.func_146272_n()) {
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound sound = tagList.func_150305_b(i);
                        tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sound", (Object[])new Object[]{sound.func_74779_i("sound")}));
                    }
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{0}));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.mode.black_list", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{0}));
        }
    }

    public boolean shouldMuffleSound(ItemStack stack, ResourceLocation sound) {
        NBTTagList tags;
        boolean isWhiteList;
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound.func_74764_b("disabled")) {
            return false;
        }
        boolean bl = isWhiteList = compound.func_74764_b("whiteList") && compound.func_74767_n("whiteList");
        if (compound.func_74764_b("sounds") && this.containsSound(tags = compound.func_150295_c("sounds", 10), sound)) {
            return !isWhiteList;
        }
        return isWhiteList;
    }

    public void toggleWhiteList(ItemStack stack) {
        boolean isWhiteList = false;
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_74764_b("whiteList")) {
                isWhiteList = compound.func_74767_n("whiteList");
            }
            compound.func_74757_a("whiteList", !isWhiteList);
            stack.func_77982_d(compound);
        } else {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("whiteList", !isWhiteList);
            stack.func_77982_d(compound);
        }
    }

    public void muffleSound(ItemStack stack, ResourceLocation sound) {
        NBTTagList tags;
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagList nBTTagList = tags = compound.func_74764_b("sounds") ? compound.func_150295_c("sounds", 10) : new NBTTagList();
        if (this.containsSound(tags, sound)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("sound", sound.toString());
        tags.func_74742_a((NBTBase)tag);
        compound.func_74782_a("sounds", (NBTBase)tags);
        stack.func_77982_d(compound);
    }

    public void unmuffleSound(ItemStack stack, ResourceLocation sound) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("sounds")) {
            NBTTagList tags = compound.func_150295_c("sounds", 10);
            NBTTagList newTags = new NBTTagList();
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound s = tags.func_150305_b(i);
                String soundLocation = s.func_74779_i("sound");
                if (soundLocation.equals(sound.toString())) continue;
                newTags.func_74742_a((NBTBase)s);
            }
            compound.func_74782_a("sounds", (NBTBase)newTags);
            stack.func_77982_d(compound);
        }
    }

    private boolean containsSound(NBTTagList tags, ResourceLocation sound) {
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound s = tags.func_150305_b(i);
            String soundLocation = s.func_74779_i("sound");
            if (!soundLocation.equals(sound.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isDisabled(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            return compound.func_74764_b("disabled");
        }
        return false;
    }

    private void toggleDisabled(EntityPlayer playerIn, ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_74764_b("disabled")) {
                compound.func_82580_o("disabled");
                stack.func_77982_d(compound);
                playerIn.func_184185_a(SoundEvents.field_187604_bf, 0.1f, 1.0f);
            } else {
                compound.func_74757_a("disabled", true);
                stack.func_77982_d(compound);
                playerIn.func_184185_a(SoundEvents.field_187604_bf, 0.1f, 0.8f);
            }
        } else {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("disabled", true);
            stack.func_77982_d(compound);
            playerIn.func_184185_a(SoundEvents.field_187604_bf, 0.1f, 0.8f);
        }
    }
}

