/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.server.command;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import thecodex6824.thaumicaugmentation.server.command.sub.ISubCommand;
import thecodex6824.thaumicaugmentation.server.command.sub.SubCommandFixAura;
import thecodex6824.thaumicaugmentation.server.command.sub.SubCommandMakeFracture;
import thecodex6824.thaumicaugmentation.server.command.sub.SubCommandWard;

public class CommandTAGeneral
implements ICommand {
    protected static final ImmutableList<String> ALIASES = ImmutableList.of((Object)"thaumicaugmentation", (Object)"ta");
    protected HashMap<String, ISubCommand> subCommands = new HashMap();

    private void putSubCommand(ISubCommand c) {
        this.subCommands.put(c.getName().toLowerCase(), c);
    }

    public CommandTAGeneral() {
        this.putSubCommand(new SubCommandFixAura());
        this.putSubCommand(new SubCommandWard());
        this.putSubCommand(new SubCommandMakeFracture());
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, "thaumicaugmentation");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            ISubCommand command = this.subCommands.get(args[0].toLowerCase());
            if (command == null) throw new CommandException("thaumicaugmentation.command.invalid_command", new Object[0]);
            command.execute(server, sender, Arrays.copyOfRange(args, 1, args.length));
            return;
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.subcommands", new Object[0]));
            for (String s : this.subCommands.keySet()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(s));
            }
        }
    }

    public List<String> func_71514_a() {
        return ALIASES;
    }

    public String func_71517_b() {
        return "thaumicaugmentation";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ISubCommand command;
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, (Collection)this.subCommands.values().stream().map(v -> v.getName()).collect(Collectors.toList()));
        }
        if (args.length > 1 && (command = this.subCommands.get(args[0].toLowerCase())) != null) {
            return command.getTabCompletions(server, sender, Arrays.copyOfRange(args, 1, args.length), targetPos);
        }
        return Collections.emptyList();
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder base = new StringBuilder(this.func_71517_b() + " <");
        for (ISubCommand c : this.subCommands.values()) {
            base.append(c.getName() + "|");
        }
        return base.append(">").toString();
    }

    public boolean func_82358_a(String[] args, int index) {
        ISubCommand command;
        if (args.length >= 1 && (command = this.subCommands.get(args[0].toLowerCase())) != null) {
            return command.isUsernameIndex(Arrays.copyOfRange(args, 1, args.length), index - 1);
        }
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }
}

