/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerWorldAddTile
extends Transformer {
    private static final String CLASS = "net.minecraft.world.World";

    @Override
    public boolean needToComputeFrames() {
        return true;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return false;
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            Type tileType = Type.getType((String)"Lnet/minecraft/tileentity/TileEntity;");
            Type blockPosType = Type.getType((String)"Lnet/minecraft/util/math/BlockPos;");
            MethodNode update = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/world/World", "func_72939_s", Type.VOID_TYPE, new Type[0]), "()V");
            int call = TransformUtil.findLastInstanceOfMethodCall(update, update.instructions.size(), TransformUtil.remapMethodName("net/minecraft/world/chunk/Chunk", "func_177426_a", Type.VOID_TYPE, blockPosType, tileType), "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "net/minecraft/world/chunk/Chunk");
            if (call == -1) {
                throw new TransformerException("Could not locate required instructions");
            }
            LabelNode target = new LabelNode(new Label());
            InsnList insns = new InsnList();
            insns.add((AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "onAddTile", "(Lnet/minecraft/world/chunk/Chunk;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)Z", false));
            insns.add((AbstractInsnNode)new JumpInsnNode(153, target));
            insns.add((AbstractInsnNode)new VarInsnNode(25, 4));
            insns.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", TransformUtil.remapMethodName("net/minecraft/tileentity/TileEntity", "func_174877_v", blockPosType, new Type[0]), "()Lnet/minecraft/util/math/BlockPos;", false));
            insns.add((AbstractInsnNode)new VarInsnNode(25, 3));
            update.instructions.insert(update.instructions.get(call), (AbstractInsnNode)target);
            update.instructions.insert(update.instructions.get(call).getPrevious(), insns);
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

