/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerTCBlueprintCrashFix
extends Transformer {
    private static final String CLASS = "thaumcraft.client.gui.GuiResearchPage";

    @Override
    public boolean needToComputeFrames() {
        return true;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return false;
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode render = TransformUtil.findMethod(classNode, "renderBluePrint", "(Lthaumcraft/client/gui/GuiResearchPage$BlueprintBlockAccess;IIF[[[Lthaumcraft/api/crafting/Part;II[Lnet/minecraft/item/ItemStack;)V");
            int offset = TransformUtil.findFirstInstanceOfMethodCall(render, 0, "createTileEntity", "(Lnet/minecraft/world/World;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/tileentity/TileEntity;", "net/minecraft/block/Block");
            int nextLabel = TransformUtil.findFirstLabel(render, offset);
            int afterRenderJump = TransformUtil.findLastInstanceOfOpcode(render, offset, 154);
            int afterRegularTileRender = TransformUtil.findFirstInstanceOfMethodCall(render, offset, TransformUtil.remapMethodName("net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "func_147549_a", Type.VOID_TYPE, Type.getType((String)"Lnet/minecraft/tileentity/TileEntity;"), Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.FLOAT_TYPE), "(Lnet/minecraft/tileentity/TileEntity;DDDF)V", "net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher");
            if (offset == -1 || nextLabel == -1 || afterRenderJump == -1 || afterRegularTileRender == -1) {
                throw new TransformerException("Could not locate required instructions");
            }
            LabelNode nLabel = (LabelNode)render.instructions.get(nextLabel);
            JumpInsnNode jump = (JumpInsnNode)render.instructions.get(afterRenderJump);
            AbstractInsnNode afterRender = render.instructions.get(afterRegularTileRender);
            render.instructions.insert(afterRender, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/renderer/texture/TextureManager", TransformUtil.remapMethodName("net/minecraft/client/renderer/texture/TextureManager", "func_110577_a", Type.VOID_TYPE, Type.getType((String)"Lnet/minecraft/util/ResourceLocation;")), "(Lnet/minecraft/util/ResourceLocation;)V", false));
            render.instructions.insert(afterRender, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/client/renderer/texture/TextureMap", TransformUtil.remapFieldName("net/minecraft/client/renderer/texture/TextureMap", "field_110575_b"), "Lnet/minecraft/util/ResourceLocation;"));
            render.instructions.insert(afterRender, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/Minecraft", TransformUtil.remapMethodName("net/minecraft/client/Minecraft", "func_110434_K", Type.getType((String)"Lnet/minecraft/client/renderer/texture/TextureManager;"), new Type[0]), "()Lnet/minecraft/client/renderer/texture/TextureManager;", false));
            render.instructions.insert(afterRender, (AbstractInsnNode)new FieldInsnNode(180, "thaumcraft/client/gui/GuiResearchPage", TransformUtil.remapFieldName("net/minecraft/client/gui/GuiScreen", "field_146297_k"), "Lnet/minecraft/client/Minecraft;"));
            render.instructions.insert(afterRender, (AbstractInsnNode)new VarInsnNode(25, 0));
            AbstractInsnNode insertAfter = render.instructions.get(offset).getNext();
            render.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(167, jump.label));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/client/internal/TAHooksClient", "renderFastTESRBlueprint", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/util/math/BlockPos;Lthaumcraft/client/gui/GuiResearchPage$BlueprintBlockAccess;)V", false));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 17));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 22));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, nLabel));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", "hasFastRenderer", "()Z", false));
            render.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 22));
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

