/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.structure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.api.world.TABiomes;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGuardian;
import thecodex6824.thaumicaugmentation.common.world.ITAChunkGenerator;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireComponent;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireComponentPlacer;

public class MapGenEldritchSpire
extends MapGenStructure {
    protected static final ImmutableList<Biome.SpawnListEntry> MONSTER_SPAWNS = ImmutableList.of((Object)new Biome.SpawnListEntry(EntityTAEldritchGuardian.class, 1, 1, 2));
    protected static final ImmutableList<Biome> BIOMES = ImmutableList.of((Object)TABiomes.EMPTINESS, (Object)TABiomes.EMPTINESS_HIGHLANDS);
    protected ITAChunkGenerator generator;

    public MapGenEldritchSpire(ITAChunkGenerator chunkGenerator) {
        this.generator = chunkGenerator;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int dist = TAConfig.spireSpacing.getValue();
        int x = chunkX;
        int z = chunkZ;
        if (x < 0) {
            x -= dist;
        }
        if (z < 0) {
            z -= dist;
        }
        int randX = x / dist;
        int randZ = z / dist;
        Random random = this.field_75039_c.func_72843_D(randX, randZ, 10387319);
        randX *= dist;
        randZ *= dist;
        if (chunkX == (randX += (random.nextInt(dist / 2 - 1) + random.nextInt(dist / 2 - 1)) / 2) && chunkZ == (randZ += (random.nextInt(dist / 2 - 1) + random.nextInt(dist / 2 - 1)) / 2)) {
            return this.field_75039_c.field_73011_w.func_177499_m().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 32, BIOMES);
        }
        return false;
    }

    @Nullable
    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        BiomeProvider p = world.func_72959_q();
        if (p.func_190944_c() && !BIOMES.contains((Object)p.func_190943_d())) {
            return null;
        }
        return MapGenEldritchSpire.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)TAConfig.spireSpacing.getValue(), (int)TAConfig.spireMinDist.getValue(), (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    public String func_143025_a() {
        return "EldritchSpire";
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.generator, this.field_75038_b, chunkX, chunkZ);
    }

    @Nullable
    public StructureStart func_175797_c(BlockPos pos) {
        return super.func_175797_c(pos);
    }

    public List<Biome.SpawnListEntry> getSpawnableCreatures(EnumCreatureType type, BlockPos pos) {
        if (type == EnumCreatureType.MONSTER && ThreadLocalRandom.current().nextBoolean()) {
            return MONSTER_SPAWNS;
        }
        return ImmutableList.of();
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"EldritchSpire");
        EldritchSpireComponentPlacer.register();
    }

    public static class Start
    extends StructureStart {
        protected boolean valid;
        protected UUID ward;

        public Start() {
            this.ward = IWardStorageServer.NIL_UUID;
        }

        public Start(World world, ITAChunkGenerator generator, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.ward = WardHelper.generateSafeUUID(random);
            Rotation rot = Rotation.values()[random.nextInt(Rotation.values().length)];
            ChunkPrimer primer = new ChunkPrimer();
            generator.populatePrimerWithHeightmap(chunkX, chunkZ, primer);
            int x = 5;
            int z = 5;
            if (rot == Rotation.CLOCKWISE_90) {
                x = -5;
            } else if (rot == Rotation.CLOCKWISE_180) {
                x = -5;
                z = -5;
            } else if (rot == Rotation.COUNTERCLOCKWISE_90) {
                z = -5;
            }
            int height1 = primer.func_186138_a(7, 7);
            int height2 = primer.func_186138_a(7, 7 + z);
            int height3 = primer.func_186138_a(7 + x, 7);
            int height4 = primer.func_186138_a(7 + x, 7 + z);
            int minHeight = Math.min(Math.min(height1, height2), Math.min(height3, height4));
            if (minHeight >= 2) {
                BlockPos pos = new BlockPos(chunkX * 16 + 8, minHeight + 1, chunkZ * 16 + 8);
                ArrayList<EldritchSpireComponent> pieces = new ArrayList<EldritchSpireComponent>();
                EldritchSpireComponentPlacer.generate(world, generator, world.func_72860_G().func_186340_h(), pos, rot, random, pieces, this.ward);
                this.field_75075_a.addAll(pieces);
                this.func_75072_c();
                this.valid = true;
            }
        }

        public void func_75068_a(World world, Random rand, StructureBoundingBox structurebb) {
            super.func_75068_a(world, rand, structurebb);
            for (StructureComponent component : this.field_75075_a) {
                if (!(component instanceof EldritchSpireComponent)) continue;
                ((EldritchSpireComponent)component).onPostGeneration(world, structurebb);
            }
        }

        public boolean func_75069_d() {
            return this.valid;
        }

        public UUID getWard() {
            return this.ward;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("valid", this.valid);
            tagCompound.func_186854_a("ward", this.ward);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.valid = tagCompound.func_74767_n("valid");
            this.ward = tagCompound.func_186857_a("ward");
            if (this.ward == null) {
                this.ward = IWardStorageServer.NIL_UUID;
            }
        }
    }
}

