/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.biome;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.world.aura.AuraHandler;
import thaumcraft.common.world.biomes.BiomeHandler;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationAuraControl;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationHandler;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationJEID;
import thecodex6824.thaumicaugmentation.common.network.PacketBiomeUpdate;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.TriConsumer;

public final class BiomeUtil {
    private static final TriConsumer<World, BlockPos, Biome> JEID_SET_BIOME = (world, pos, biome) -> BiomeUtil.invoke((w, p, b) -> ((IntegrationJEID)IntegrationHandler.getIntegration("jeid")).setBiomeJEID((World)w, (BlockPos)p, (Biome)b), world, pos, biome);
    private static final TriConsumer<World, Integer, Integer> AURACONTROL_HANDLE_AURA = (world, chunkX, chunkZ) -> BiomeUtil.invoke((w, x, z) -> ((IntegrationAuraControl)IntegrationHandler.getIntegration("auracontrol")).handleAura((World)w, (int)x, (int)z), world, chunkX, chunkZ);

    private BiomeUtil() {
    }

    private static <A, B, C> void invoke(TriConsumer<A, B, C> consumer, A a, B b, C c) {
        consumer.accept(a, b, c);
    }

    public static void setBiome(World world, BlockPos pos, Biome newBiome) {
        if (IntegrationHandler.isIntegrationPresent("jeid")) {
            JEID_SET_BIOME.accept(world, pos, newBiome);
        } else {
            Chunk chunk = world.func_175726_f(pos);
            byte[] array = chunk.func_76605_m();
            array[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)newBiome);
            if (!world.field_72995_K) {
                world.func_175646_b(pos, null);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketBiomeUpdate(pos.func_177958_n(), pos.func_177952_p(), Biome.func_185362_a((Biome)newBiome)), point);
            } else {
                world.func_72975_g(pos.func_177958_n(), pos.func_177952_p(), 0, 255);
            }
        }
    }

    public static void resetBiome(World world, BlockPos pos) {
        Biome biome;
        Biome[] biomeArray = world.func_72959_q().func_76937_a(null, (pos.func_177958_n() >> 2) - 2, (pos.func_177952_p() >> 2) - 2, 1, 1);
        if (biomeArray != null && biomeArray.length > 0 && (biome = biomeArray[0]) != null) {
            BiomeUtil.setBiome(world, pos, biome);
        }
    }

    public static Biome getNaturalBiome(World world, BlockPos pos, @Nullable Biome fallback) {
        Biome biome;
        Biome[] biomeArray = world.func_72959_q().func_76937_a(null, (pos.func_177958_n() >> 2) - 2, (pos.func_177952_p() >> 2) - 2, 1, 1);
        if (biomeArray != null && biomeArray.length > 0 && (biome = biomeArray[0]) != null) {
            ResourceLocation registryLoc = biome.getRegistryName();
            return (Biome)Biome.field_185377_q.func_82594_a((Object)registryLoc);
        }
        return fallback;
    }

    public static boolean areBiomesSame(Biome first, Biome second) {
        return first.getRegistryName().equals((Object)second.getRegistryName());
    }

    public static boolean areBiomesSame(World world, BlockPos pos, Biome first) {
        return BiomeUtil.areBiomesSame(world.func_180494_b(pos), first);
    }

    public static boolean isNaturalBiomePresent(World world, BlockPos pos) {
        Biome natural = BiomeUtil.getNaturalBiome(world, pos, null);
        return natural != null && BiomeUtil.areBiomesSame(world, pos, natural);
    }

    /*
     * Exception decompiling
     */
    private static Random copyRand(Random rand) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean generateNewAura(World world, BlockPos pos, boolean preserveFlux) {
        Biome biome = world.func_180494_b(pos);
        if (BiomeHandler.getBiomeBlacklist((int)Biome.func_185362_a((Biome)biome)) != -1) {
            return false;
        }
        float life = BiomeHandler.getBiomeAuraModifier((Biome)biome);
        for (EnumFacing face : EnumFacing.field_176754_o) {
            Biome b = world.func_180494_b(pos.func_177967_a(face, 16));
            life += BiomeHandler.getBiomeAuraModifier((Biome)b);
        }
        life /= 5.0f;
        int target = AuraHelper.getAuraBase((World)world, (BlockPos)pos);
        float flux = AuraHelper.getFlux((World)world, (BlockPos)pos);
        float vis = AuraHelper.getVis((World)world, (BlockPos)pos);
        Random chunkRandom = new Random(world.func_72905_C());
        long xSeed = chunkRandom.nextLong() >> 3;
        long zSeed = chunkRandom.nextLong() >> 3;
        chunkRandom.setSeed(xSeed * (long)(pos.func_177958_n() >> 16) + zSeed * (long)(pos.func_177952_p() >> 16) ^ world.func_72905_C());
        for (int i = 0; i < 8; ++i) {
            chunkRandom.nextInt();
        }
        Random copy = BiomeUtil.copyRand(chunkRandom);
        boolean solutionFound = false;
        for (int i = 0; i < 32768; ++i) {
            double g = chunkRandom.nextGaussian();
            if (MathHelper.func_76125_a((int)((short)((float)(1.0 + g * (double)0.1f) * life * 500.0f)), (int)0, (int)500) == target) {
                solutionFound = true;
                break;
            }
            chunkRandom = copy;
            chunkRandom.nextBoolean();
            copy = BiomeUtil.copyRand(chunkRandom);
        }
        Chunk chunk = world.func_175726_f(pos);
        AuraHandler.generateAura((Chunk)chunk, (Random)copy);
        chunk.func_76630_e();
        if (IntegrationHandler.isIntegrationPresent("auracontrol")) {
            AURACONTROL_HANDLE_AURA.accept(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            solutionFound = true;
        }
        float applyVis = Math.min(Math.min(vis, AuraHelper.getVis((World)world, (BlockPos)pos)), (float)AuraHelper.getAuraBase((World)world, (BlockPos)pos));
        AuraHelper.drainVis((World)world, (BlockPos)pos, (float)(AuraHelper.getVis((World)world, (BlockPos)pos) - applyVis), (boolean)false);
        if (preserveFlux) {
            AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)flux, (boolean)false);
        }
        return solutionFound;
    }

    public static Aspect getAspectForType(BiomeDictionary.Type type, Aspect fallback) {
        Object thing;
        List stuff = (List)BiomeHandler.biomeInfo.get(type);
        if (stuff != null && stuff.size() >= 2 && (thing = stuff.get(1)) instanceof Aspect) {
            return (Aspect)thing;
        }
        return fallback;
    }
}

