/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.util.maze;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import thecodex6824.thaumicaugmentation.common.util.maze.Maze;
import thecodex6824.thaumicaugmentation.common.util.maze.MazeCell;

public class MazeGenerator {
    protected int width = 3;
    protected int length = 3;

    public MazeGenerator withSize(int mazeWidth, int mazeLength) {
        this.width = mazeWidth;
        this.length = mazeLength;
        return this;
    }

    public Maze generate(Random rand) {
        MazeCell[] cells = new MazeCell[this.width * this.length];
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = new MazeCell();
        }
        ImmutableList directionOffsets = ImmutableList.of((Object)(-this.length), (Object)1, (Object)this.length, (Object)-1);
        ArrayList dirChoices = new ArrayList();
        IntOpenHashSet visited = new IntOpenHashSet();
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        int initial = rand.nextInt(cells.length);
        visited.add(initial);
        stack.push(initial);
        while (!stack.isEmpty()) {
            int current = (Integer)stack.pop();
            int neighborDir = 0;
            dirChoices.clear();
            dirChoices.addAll(directionOffsets);
            while (!dirChoices.isEmpty()) {
                int i = rand.nextInt(dirChoices.size());
                int dir = (Integer)dirChoices.get(i);
                int check = current + dir;
                if (dir == -1 || dir == 1) {
                    if (check > -1 && check < cells.length && check / this.length == current / this.length && !visited.contains(check)) {
                        neighborDir = dir;
                        break;
                    }
                } else if (check > -1 && check < cells.length && check % this.length == current % this.length && !visited.contains(check)) {
                    neighborDir = dir;
                    break;
                }
                dirChoices.remove(i);
            }
            if (neighborDir == 0) continue;
            int otherIndex = current + neighborDir;
            MazeCell cell = cells[current];
            MazeCell other = cells[otherIndex];
            if (neighborDir == -1) {
                cell.setWall(EnumFacing.WEST, false);
                other.setWall(EnumFacing.EAST, false);
            } else if (neighborDir == 1) {
                cell.setWall(EnumFacing.EAST, false);
                other.setWall(EnumFacing.WEST, false);
            } else if (neighborDir == -this.length) {
                cell.setWall(EnumFacing.NORTH, false);
                other.setWall(EnumFacing.SOUTH, false);
            } else {
                cell.setWall(EnumFacing.SOUTH, false);
                other.setWall(EnumFacing.NORTH, false);
            }
            stack.push(current);
            stack.push(otherIndex);
            visited.add(otherIndex);
        }
        return new Maze(this.width, this.length, cells);
    }
}

