/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.api.aspects.Aspect;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class TileVoidRechargePedestal
extends TileEntity
implements ITickable {
    protected ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.hasCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) {
                return true;
            }
            IAugmentableItem item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
            if (item != null) {
                for (ItemStack s : item.getAllAugments()) {
                    if (!s.hasCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) continue;
                    return true;
                }
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileVoidRechargePedestal.this.func_70296_d();
            TileVoidRechargePedestal.this.field_145850_b.func_184138_a(TileVoidRechargePedestal.this.field_174879_c, TileVoidRechargePedestal.this.field_145850_b.func_180495_p(TileVoidRechargePedestal.this.field_174879_c), TileVoidRechargePedestal.this.field_145850_b.func_180495_p(TileVoidRechargePedestal.this.field_174879_c), 6);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    protected SimpleImpetusConsumer consumer = new SimpleImpetusConsumer(1, 0);
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected int lastResult = -1;

    public int getComparatorOutput() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        IImpetusStorage storage = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        if (storage != null) {
            return (int)((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() * 15.0);
        }
        return 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 10 == 0) {
            int level;
            ItemStack stack;
            if (this.ticks % 20 == 0) {
                NodeHelper.validate(this.consumer, this.field_145850_b);
            }
            if (!(stack = this.inventory.getStackInSlot(0)).func_190926_b()) {
                IAugmentableItem aug;
                boolean sync = false;
                ArrayList<Map<Deque<IImpetusNode>, Long>> transactions = new ArrayList<Map<Deque<IImpetusNode>, Long>>();
                IImpetusStorage storage = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                if (storage != null) {
                    long receivable = storage.receiveEnergy(Long.MAX_VALUE, true);
                    ConsumeResult consumeResult = this.consumer.consume(receivable, false);
                    if (storage.receiveEnergy(consumeResult.energyConsumed, false) > 0L) {
                        sync = true;
                        transactions.add(consumeResult.paths);
                    }
                }
                if ((aug = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                    for (ItemStack augment : aug.getAllAugments()) {
                        storage = (IImpetusStorage)augment.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                        if (storage == null) continue;
                        long receivable = storage.receiveEnergy(Long.MAX_VALUE, true);
                        ConsumeResult consume = this.consumer.consume(receivable, false);
                        if (storage.receiveEnergy(consume.energyConsumed, false) <= 0L) continue;
                        sync = true;
                        transactions.add(consume.paths);
                    }
                }
                if (sync) {
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 6);
                    for (Map map : transactions) {
                        NodeHelper.syncAllImpetusTransactions(map.keySet());
                        for (Map.Entry entry : map.entrySet()) {
                            NodeHelper.damageEntitiesFromTransaction((Deque<IImpetusNode>)((Deque)entry.getKey()), (Long)entry.getValue());
                        }
                    }
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.25, (double)this.field_174879_c.func_177956_o() + 0.9 + (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.25, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.25, 1.5, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                }
            }
            if ((level = this.getComparatorOutput()) != this.lastResult) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.lastResult = level;
            }
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.inventory.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.inventory.deserializeNBT(pkt.func_148857_g());
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.consumer);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.consumer);
        }
        this.consumer.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.consumer.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        tag.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.consumer.deserializeNBT(nbt.func_74775_l("node"));
        this.inventory.deserializeNBT(nbt.func_74775_l("inv"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        tag.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NodeHelper.tryConnectNewlyLoadedPeers(this.consumer, this.field_145850_b);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return capability == CapabilityImpetusNode.IMPETUS_NODE ? true : super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.consumer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

