/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.aspects.Aspect;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.event.RiftJarVoidItemEvent;
import thecodex6824.thaumicaugmentation.api.tile.CapabilityRiftJar;
import thecodex6824.thaumicaugmentation.api.tile.RiftJar;
import thecodex6824.thaumicaugmentation.api.util.FluxRiftReconstructor;
import thecodex6824.thaumicaugmentation.common.network.PacketRiftJarInstability;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class TileRiftJar
extends TileEntity
implements ITickable {
    protected RiftJar rift = new RiftJar(0, 0){

        @Override
        public void setRift(FluxRiftReconstructor newRift) {
            super.setRift(newRift);
            if (!((TileRiftJar)TileRiftJar.this).field_145850_b.field_72995_K) {
                TileRiftJar.this.func_70296_d();
                TileRiftJar.this.field_145850_b.func_184138_a(TileRiftJar.this.field_174879_c, TileRiftJar.this.field_145850_b.func_180495_p(TileRiftJar.this.field_174879_c), TileRiftJar.this.field_145850_b.func_180495_p(TileRiftJar.this.field_174879_c), 2);
            }
        }
    };
    protected IItemHandler inventory = new VoidInventory();
    protected int stability;
    protected long lastStabilityUpdate;

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() - this.lastStabilityUpdate >= 100L) {
            this.setRiftStability(Math.min(0, (int)((long)this.stability + this.lastStabilityUpdate / 100L)));
        }
    }

    public void setRiftStability(int newStability) {
        if (this.stability != newStability) {
            this.stability = newStability;
            this.lastStabilityUpdate = this.field_145850_b.func_82737_E();
            if (!this.field_145850_b.field_72995_K) {
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketRiftJarInstability(this.field_174879_c, this.stability), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
            } else {
                ThaumicAugmentation.proxy.getRenderHelper().renderSpark(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.1865 + this.field_145850_b.field_73012_v.nextDouble() * 0.626, (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * 0.75, (double)this.field_174879_c.func_177952_p() + 0.1865 + this.field_145850_b.field_73012_v.nextDouble() * 0.626, 1.5f, Aspect.ELDRITCH.getColor(), false);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.rift.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.rift.deserializeNBT(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("rift", (NBTBase)this.rift.serializeNBT());
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.rift.hasRift();
        }
        return capability == CapabilityRiftJar.RIFT_JAR ? true : super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.rift.hasRift()) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityRiftJar.RIFT_JAR) {
            return (T)CapabilityRiftJar.RIFT_JAR.cast((Object)this.rift);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("rift", (NBTBase)this.rift.serializeNBT());
        compound.func_74768_a("stability", this.stability);
        compound.func_74772_a("lastStabUpdate", this.lastStabilityUpdate);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rift.deserializeNBT(compound.func_74775_l("rift"));
        if (compound.func_150297_b("stability", 3)) {
            this.stability = compound.func_74762_e("stability");
        }
        if (compound.func_150297_b("lastStabUpdate", 4)) {
            this.lastStabilityUpdate = compound.func_74763_f("lastStabUpdate");
        }
    }

    protected class VoidInventory
    implements IItemHandler {
        protected VoidInventory() {
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            RiftJarVoidItemEvent event = new RiftJarVoidItemEvent(stack, TileRiftJar.this.rift, TileRiftJar.this.field_145850_b, TileRiftJar.this.field_174879_c, simulate);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!simulate) {
                    TileRiftJar.this.setRiftStability(Math.max(TileRiftJar.this.stability - stack.func_190916_E() * 3, -200));
                }
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public int getSlots() {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    }
}

