/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class PacketImpetusTransaction
implements IMessage {
    public static int maxPathLength = 1024;
    private DimensionalBlockPos[] positions;

    public PacketImpetusTransaction() {
    }

    public PacketImpetusTransaction(DimensionalBlockPos[] path) {
        this.positions = Arrays.copyOf(path, path.length);
    }

    public void fromBytes(ByteBuf buf) {
        byte[] buffer = new byte[Math.min(buf.readInt(), maxPathLength * 16)];
        buf.readBytes(buffer);
        try (DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(buffer)));){
            this.positions = new DimensionalBlockPos[Math.min(stream.readInt(), maxPathLength)];
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = new DimensionalBlockPos(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
            }
        }
        catch (IOException ex) {
            ThaumicAugmentation.getLogger().error("Unable to deserialize PacketImpetusTransaction: " + ex.getMessage());
        }
    }

    public void toBytes(ByteBuf buf) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream(4 + this.positions.length * 4 * 4);
             DataOutputStream data = new DataOutputStream(new GZIPOutputStream(stream));){
            data.writeInt(this.positions.length);
            for (DimensionalBlockPos pos : this.positions) {
                data.writeInt(pos.getPos().func_177958_n());
                data.writeInt(pos.getPos().func_177956_o());
                data.writeInt(pos.getPos().func_177952_p());
                data.writeInt(pos.getDimension());
            }
            data.close();
            byte[] buffer = stream.toByteArray();
            buf.writeInt(buffer.length);
            buf.writeBytes(buffer);
        }
        catch (IOException ex) {
            ThaumicAugmentation.getLogger().error("Unable to serialize PacketImpetusTransaction: " + ex.getMessage());
        }
    }

    public DimensionalBlockPos[] getPositions() {
        return this.positions;
    }
}

