/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item.builder;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.aspect.AspectElementInteractionManager;
import thecodex6824.thaumicaugmentation.api.aspect.AspectUtil;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.IBuilderCasterStrengthProvider;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.ICustomCasterAugment;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;

public class StrengthProviderElemental
implements IBuilderCasterStrengthProvider {
    private Aspect getAspect(ItemStack stack) {
        if (!stack.func_77942_o() || Aspect.getAspect((String)stack.func_77978_p().func_74779_i("aspect")) == null) {
            return Aspect.ORDER;
        }
        return Aspect.getAspect((String)stack.func_77978_p().func_74779_i("aspect"));
    }

    @Override
    public void appendAdditionalTooltip(ItemStack component, List<String> tooltip) {
        Aspect aspect = this.getAspect(component);
        tooltip.add("  " + new TextComponentTranslation("thaumicaugmentation.text.elemental_aspect", new Object[]{AspectUtil.getChatColorForAspect(aspect) + aspect.getName() + TextFormatting.RESET}).func_150254_d());
    }

    @Override
    public int calculateTintColor(ICustomCasterAugment augment) {
        return this.getAspect(augment.getStrengthProvider()).getColor();
    }

    @Override
    public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
        double totalMultiplier = 1.0;
        boolean positive = false;
        HashSet<Aspect> negatives = new HashSet<Aspect>();
        ArrayDeque nodes = new ArrayDeque(focus.getFocus().nodes);
        while (!nodes.isEmpty()) {
            IFocusElement node = (IFocusElement)nodes.pop();
            if (!positive && node instanceof FocusEffect && ((FocusEffect)node).getAspect() == this.getAspect(augment.getStrengthProvider())) {
                totalMultiplier *= TAConfig.elementalModifierPositiveFactor.getValue().doubleValue();
                positive = true;
                continue;
            }
            if (node instanceof FocusModSplit) {
                for (FocusPackage f : ((FocusModSplit)node).getSplitPackages()) {
                    nodes.addAll(f.nodes);
                }
                continue;
            }
            if (!(node instanceof FocusNode) || negatives.contains(((FocusNode)node).getAspect())) continue;
            Aspect strengthAspect = this.getAspect(augment.getStrengthProvider());
            Aspect nodeAspect = ((FocusNode)node).getAspect();
            if (!AspectElementInteractionManager.getNegativeAspects(strengthAspect).contains(nodeAspect) || !negatives.add(nodeAspect)) continue;
            totalMultiplier *= TAConfig.elementalModifierNegativeFactor.getValue().doubleValue();
        }
        return totalMultiplier;
    }
}

