/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.objectweb.asm.Type;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;

public class TCSoundFixer {
    protected static final String ON_ITEM_RIGHT_CLICK = TransformUtil.remapMethodName("net/minecraft/item/Item", "func_77659_a", Type.getType(ActionResult.class), Type.getType(World.class), Type.getType(EntityPlayer.class), Type.getType(EnumHand.class));
    protected static final String ON_ITEM_USE_FIRST = "onItemUseFirst";
    protected static final String ON_USING_TICK = "onUsingTick";
    protected static final String CASTER_MANAGER = "thaumcraft.common.items.casters.CasterManager";
    protected static final String CHANGE_FOCUS = "changeFocus";
    protected static final String LOOT_BAG = "thaumcraft.common.items.curios.ItemLootBag";
    protected static final String PHIAL = "thaumcraft.common.items.consumables.ItemPhial";
    protected static final String WIND_SWORD = "thaumcraft.common.items.tools.ItemElementalSword";
    protected static final String HAND_MIRROR = "thaumcraft.common.items.tools.ItemHandMirror";
    protected static final String HAND_MIRROR_TRANSPORT = "transport";
    protected static final String JAR_ITEM = "thaumcraft.common.blocks.essentia.BlockJarItem";

    protected static boolean frameMatches(StackTraceElement frame, String className, String methodName) {
        return frame.getClassName().equals(className) && frame.getMethodName().equals(methodName);
    }

    protected static void correctAndCancelSound(PlaySoundAtEntityEvent event) {
        event.getEntity().func_130014_f_().func_184133_a(null, event.getEntity().func_180425_c(), event.getSound(), event.getCategory(), event.getDefaultVolume(), event.getDefaultPitch());
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void fixEntitySounds(PlaySoundAtEntityEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().func_130014_f_().field_72995_K) {
            StackTraceElement frame;
            StackTraceElement[] stack;
            if (event.getSound() == SoundsTC.ticks) {
                StackTraceElement frame2;
                StackTraceElement[] stack2 = new Throwable().getStackTrace();
                if (stack2.length >= 8 && TCSoundFixer.frameMatches(frame2 = stack2[7], CASTER_MANAGER, CHANGE_FOCUS)) {
                    TCSoundFixer.correctAndCancelSound(event);
                }
            } else if (event.getSound() == SoundsTC.coins) {
                StackTraceElement frame3;
                StackTraceElement[] stack3 = new Throwable().getStackTrace();
                if (stack3.length >= 8 && TCSoundFixer.frameMatches(frame3 = stack3[7], LOOT_BAG, ON_ITEM_RIGHT_CLICK)) {
                    TCSoundFixer.correctAndCancelSound(event);
                }
            } else if (event.getSound() == SoundEvents.field_187615_H) {
                StackTraceElement frame4;
                StackTraceElement[] stack4 = new Throwable().getStackTrace();
                if (stack4.length >= 8 && (TCSoundFixer.frameMatches(frame4 = stack4[7], PHIAL, ON_ITEM_USE_FIRST) || TCSoundFixer.frameMatches(frame4, JAR_ITEM, ON_ITEM_USE_FIRST))) {
                    TCSoundFixer.correctAndCancelSound(event);
                }
            } else if (event.getSound() == SoundsTC.wind) {
                StackTraceElement frame5;
                StackTraceElement[] stack5 = new Throwable().getStackTrace();
                if (stack5.length >= 8 && TCSoundFixer.frameMatches(frame5 = stack5[7], WIND_SWORD, ON_USING_TICK)) {
                    TCSoundFixer.correctAndCancelSound(event);
                }
            } else if (event.getSound() == SoundsTC.zap) {
                StackTraceElement frame6;
                StackTraceElement[] stack6 = new Throwable().getStackTrace();
                if (stack6.length >= 8 && (TCSoundFixer.frameMatches(frame6 = stack6[7], HAND_MIRROR, ON_ITEM_RIGHT_CLICK) || TCSoundFixer.frameMatches(frame6, HAND_MIRROR, HAND_MIRROR_TRANSPORT))) {
                    TCSoundFixer.correctAndCancelSound(event);
                }
            } else if (event.getSound() == SoundEvents.field_187534_aX && (stack = new Throwable().getStackTrace()).length >= 8 && TCSoundFixer.frameMatches(frame = stack[7], HAND_MIRROR, HAND_MIRROR_TRANSPORT)) {
                TCSoundFixer.correctAndCancelSound(event);
            }
        }
    }
}

