/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.RechargeHelper;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.entity.DamageSourceImpetus;
import thecodex6824.thaumicaugmentation.api.entity.PlayerMovementAbilityManager;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.item.IArmorReduceFallDamage;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.common.TAConfigHolder;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationEBWizardry;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationHandler;
import thecodex6824.thaumicaugmentation.common.network.PacketBoostState;
import thecodex6824.thaumicaugmentation.common.network.PacketFlightState;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.world.ChunkGeneratorEmptiness;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public final class PlayerEventHandler {
    private static final Consumer<LivingDamageEvent> CHECK_FIREBALL = event -> PlayerEventHandler.invoke(e -> ((IntegrationEBWizardry)IntegrationHandler.getIntegration("ebwizardry")).onDamage((LivingDamageEvent)e), event);
    private static final Set<EntityPlayer> CREATIVE_FLIGHT = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<EntityPlayer> ELYTRA_BOOSTS = Collections.newSetFromMap(new WeakHashMap());

    private static void invoke(Consumer<LivingDamageEvent> c, LivingDamageEvent t) {
        c.accept(t);
    }

    private PlayerEventHandler() {
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        TAConfigHolder.loadOrSyncConfig(event.player);
        if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)event.player, (String[])new String[]{"THAUMIC_AUGMENTATION_BASE@1"}) && (ThaumcraftCapabilities.knowsResearch((EntityPlayer)event.player, (String[])new String[]{"FIRSTSTEPS"}) || ThaumcraftCapabilities.knowsResearch((EntityPlayer)event.player, (String[])new String[]{"~FIRSTSTEPS"}))) {
            IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)event.player);
            knowledge.addResearch("THAUMIC_AUGMENTATION_BASE");
            knowledge.setResearchFlag("THAUMIC_AUGMENTATION_BASE", IPlayerKnowledge.EnumResearchFlag.RESEARCH);
            knowledge.setResearchStage("THAUMIC_AUGMENTATION_BASE", 2);
            knowledge.sync((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof EntityPlayer && PlayerMovementAbilityManager.isValidSideForMovement((EntityPlayer)event.getEntity())) {
            PlayerMovementAbilityManager.onJump((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && PlayerMovementAbilityManager.isValidSideForMovement((EntityPlayer)event.getEntity())) {
            PlayerMovementAbilityManager.onPlayerRecreation((EntityPlayer)event.getEntity());
        }
    }

    protected static void checkFrequent(EntityPlayer player) {
        WorldServer w = (WorldServer)player.func_130014_f_();
        if (w.func_72863_F().func_193413_a((World)w, "EldritchSpire", player.func_180425_c())) {
            IWardStorage storage;
            MapGenEldritchSpire.Start start;
            IPlayerKnowledge knowledge;
            if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_ENTERSPIRE"}) && (knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_ENTERSPIRE")) {
                knowledge.sync((EntityPlayerMP)player);
                player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.entered_spire", new Object[]{new TextComponentString("Spire").func_150255_a(new Style().func_150237_e(Boolean.valueOf(true)))}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
            }
            if ((player.field_71075_bZ.field_75100_b || player.func_184613_cA()) && !player.func_184812_l_() && !player.func_175149_v() && (start = ((ChunkGeneratorEmptiness)w.func_72863_F().field_186029_c).getSpireStart(player.func_180425_c())) != null && (storage = (IWardStorage)w.func_175726_f(player.func_180425_c()).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer && ((IWardStorageServer)storage).isWardOwner(start.getWard())) {
                player.field_71075_bZ.field_75100_b = false;
                player.func_70052_a(7, false);
                player.func_71016_p();
                player.func_146105_b(new TextComponentTranslation("tc.break.fly", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
            }
        }
    }

    protected static void checkResearch(EntityPlayer player) {
        IPlayerKnowledge knowledge;
        StatisticsManagerServer stats;
        IPlayerKnowledge knowledge2;
        Biome biome;
        IPlayerKnowledge knowledge3;
        if (!TAConfig.disableEmptiness.getValue().booleanValue() && player.func_130014_f_().field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a() && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_ENTERVOID"}) && (knowledge3 = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_ENTERVOID")) {
            knowledge3.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.entered_void", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if (BiomeDictionary.hasType((Biome)(biome = player.func_130014_f_().func_180494_b(player.func_180425_c())), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_OCEAN"}) && (knowledge2 = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_OCEAN")) {
            knowledge2.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.ocean", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_MOUNTAIN"}) && (knowledge2 = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_MOUNTAIN")) {
            knowledge2.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.mountain", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_DESERT"}) && (knowledge2 = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_DESERT")) {
            knowledge2.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.desert", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_FOREST"}) && (knowledge2 = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_FOREST")) {
            knowledge2.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.forest", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if ((stats = player.func_184102_h().func_184103_al().func_152602_a(player)).func_77444_a(StatList.field_188110_v) > 199999 && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_ELYTRAFLY"}) && (knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_ELYTRAFLY")) {
            knowledge.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.elytra_fly", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if (stats.func_77444_a(StatList.field_188105_q) > 14999 && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_LONGTIMEINWATER"}) && (knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_LONGTIMEINWATER")) {
            knowledge.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.long_time_in_water", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        if (player.func_70660_b(MobEffects.field_188424_y) != null && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"m_LEVITATE"}) && (knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player)).addResearch("m_LEVITATE")) {
            knowledge.sync((EntityPlayerMP)player);
            player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.levitate", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
    }

    public static boolean getBoostState(EntityPlayer player) {
        return ELYTRA_BOOSTS.contains(player);
    }

    public static void updateBoostState(EntityPlayer player, boolean boost) {
        if (boost) {
            ELYTRA_BOOSTS.add(player);
        } else {
            ELYTRA_BOOSTS.remove(player);
        }
    }

    public static boolean playerCanBoost(EntityPlayer player) {
        boolean canKeepFlying = false;
        IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        if (baubles != null) {
            for (int slot : BaubleType.BODY.getValidSlots()) {
                IAugmentableItem augmentable;
                ItemStack body = baubles.getStackInSlot(slot);
                if (body.func_77973_b() == TAItems.ELYTRA_HARNESS && (augmentable = (IAugmentableItem)body.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                    for (ItemStack aug : augmentable.getAllAugments()) {
                        double current;
                        if (aug.func_77973_b() != TAItems.ELYTRA_HARNESS_AUGMENT || aug.func_77960_j() != 0) continue;
                        if (!aug.func_77942_o()) {
                            aug.func_77982_d(new NBTTagCompound());
                        }
                        if ((current = aug.func_77978_p().func_74769_h("acc") + TAConfig.elytraHarnessBoostCost.getValue()) >= 1.0) {
                            long remove = (long)Math.floor(current);
                            IImpetusStorage impetus = (IImpetusStorage)aug.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                            if (impetus != null && ImpetusAPI.tryExtractFully(impetus, remove, (Entity)player)) {
                                current -= (double)remove;
                            }
                        }
                        aug.func_77978_p().func_74780_a("acc", current);
                        if (!(current < 1.0)) continue;
                        canKeepFlying = true;
                        break;
                    }
                }
                if (canKeepFlying) break;
            }
        }
        return canKeepFlying;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            if (!player.func_130014_f_().field_72995_K) {
                Object packet;
                if (player.field_70173_aa % 2 == 0) {
                    PlayerEventHandler.checkFrequent(player);
                    if (player.field_70173_aa % 40 == 0) {
                        PlayerEventHandler.checkResearch(player);
                    }
                }
                Boolean fly = player.field_71075_bZ.field_75100_b;
                if (CREATIVE_FLIGHT.contains(player) != fly.booleanValue()) {
                    packet = new PacketFlightState(player.func_145782_y(), fly);
                    if (player instanceof EntityPlayerMP) {
                        TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
                    }
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)player);
                    if (fly.booleanValue()) {
                        CREATIVE_FLIGHT.add(player);
                    } else {
                        CREATIVE_FLIGHT.remove(player);
                    }
                }
                if (ELYTRA_BOOSTS.contains(player)) {
                    if (!PlayerEventHandler.playerCanBoost(player)) {
                        ELYTRA_BOOSTS.remove(player);
                        packet = new PacketBoostState(player.func_145782_y(), false);
                        if (player instanceof EntityPlayerMP) {
                            TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
                        }
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)player);
                    } else {
                        Vec3d vec3d = player.func_70040_Z();
                        player.field_70159_w += vec3d.field_72450_a * 0.1 + (vec3d.field_72450_a * 1.5 - player.field_70159_w) * 0.5;
                        player.field_70181_x += vec3d.field_72448_b * 0.1 + (vec3d.field_72448_b * 1.5 - player.field_70181_x) * 0.5;
                        player.field_70179_y += vec3d.field_72449_c * 0.1 + (vec3d.field_72449_c * 1.5 - player.field_70179_y) * 0.5;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFallFirst(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.field_76379_h) {
            float damage = event.getAmount();
            for (ItemStack stack : event.getEntityLiving().func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof IArmorReduceFallDamage)) continue;
                damage = ((IArmorReduceFallDamage)stack.func_77973_b()).getNewFallDamage(stack, damage, event.getEntityLiving().field_70143_R);
            }
            if ((damage = Math.max(0.0f, damage)) < 1.0f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFallHurt(LivingHurtEvent event) {
        if (event.getSource() == DamageSource.field_76379_h) {
            EntityPlayer player;
            IBaublesItemHandler baubles;
            float damage = event.getAmount();
            for (ItemStack stack : event.getEntityLiving().func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof IArmorReduceFallDamage)) continue;
                damage = ((IArmorReduceFallDamage)stack.func_77973_b()).getNewFallDamage(stack, damage, event.getEntityLiving().field_70143_R);
            }
            if (damage > 0.0f && event.getEntityLiving() instanceof EntityPlayer && (baubles = (IBaublesItemHandler)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) != null) {
                int visCost = MathHelper.func_76143_f((double)((double)damage / 5.0));
                boolean costPaid = false;
                for (int slot : BaubleType.BODY.getValidSlots()) {
                    IAugmentableItem item;
                    ItemStack inSlot = baubles.getStackInSlot(slot);
                    if (inSlot.func_77973_b() == TAItems.THAUMOSTATIC_HARNESS && (item = (IAugmentableItem)inSlot.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                        for (ItemStack augment : item.getAllAugments()) {
                            if (augment.func_77973_b() != TAItems.THAUMOSTATIC_HARNESS_AUGMENT || augment.func_77960_j() != 0 || !RechargeHelper.consumeCharge((ItemStack)inSlot, (EntityLivingBase)player, (int)visCost)) continue;
                            damage = 0.0f;
                            costPaid = true;
                            break;
                        }
                    }
                    if (costPaid) break;
                }
            }
            if ((damage = Math.max(0.0f, damage)) < 1.0f) {
                event.setAmount(0.0f);
                event.setCanceled(true);
            } else {
                event.setAmount(damage);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getSource() instanceof DamageSourceImpetus && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{"f_IMPETUSDAMAGE"})) {
                IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
                if (knowledge.addResearch("f_IMPETUSDAMAGE")) {
                    knowledge.sync((EntityPlayerMP)player);
                    player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.impetus_damage", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            } else if (IntegrationHandler.isIntegrationPresent("ebwizardry")) {
                CHECK_FIREBALL.accept(event);
            }
        }
    }

    @SubscribeEvent
    public static void onFallSound(PlaySoundAtEntityEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getSound() == SoundEvents.field_187736_dY || event.getSound() == SoundEvents.field_187804_ed) {
                boolean shouldSilenceFall = false;
                for (ItemStack stack : player.func_184193_aE()) {
                    if (!(stack.func_77973_b() instanceof IArmorReduceFallDamage)) continue;
                    shouldSilenceFall = true;
                    break;
                }
                if (shouldSilenceFall) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFlyFall(PlayerFlyableFallEvent event) {
        IBaublesItemHandler baubles;
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_184812_l_() && !player.func_175149_v() && player.field_71075_bZ.field_75101_c && (baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) != null) {
            boolean doDamage = false;
            for (int slot : BaubleType.BODY.getValidSlots()) {
                ItemStack inSlot = baubles.getStackInSlot(slot);
                if (inSlot.func_77973_b() != TAItems.THAUMOSTATIC_HARNESS) continue;
                doDamage = true;
                break;
            }
            if (doDamage) {
                player.field_71075_bZ.field_75101_c = false;
                player.func_180430_e(event.getDistance(), event.getMultiplier());
                player.field_71075_bZ.field_75101_c = true;
            }
        }
    }
}

