/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thecodex6824.thaumicaugmentation.api.item.CapabilityMorphicTool;
import thecodex6824.thaumicaugmentation.api.item.IMorphicTool;

@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public class MorphicEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUseStart(LivingEntityUseItemEvent.Start event) {
        ItemStack func;
        IMorphicTool tool = (IMorphicTool)event.getItem().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null && !(func = tool.getFunctionalStack()).func_190926_b()) {
            LivingEntityUseItemEvent.Start newEvent = new LivingEntityUseItemEvent.Start(event.getEntityLiving(), func, event.getDuration());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
            event.setDuration(newEvent.getDuration());
            event.setCanceled(newEvent.isCanceled());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUseTick(LivingEntityUseItemEvent.Tick event) {
        ItemStack func;
        IMorphicTool tool = (IMorphicTool)event.getItem().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null && !(func = tool.getFunctionalStack()).func_190926_b()) {
            LivingEntityUseItemEvent.Tick newEvent = new LivingEntityUseItemEvent.Tick(event.getEntityLiving(), func, event.getDuration());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
            event.setDuration(newEvent.getDuration());
            event.setCanceled(newEvent.isCanceled());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUseStop(LivingEntityUseItemEvent.Stop event) {
        ItemStack func;
        IMorphicTool tool = (IMorphicTool)event.getItem().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null && !(func = tool.getFunctionalStack()).func_190926_b()) {
            LivingEntityUseItemEvent.Stop newEvent = new LivingEntityUseItemEvent.Stop(event.getEntityLiving(), func, event.getDuration());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
            event.setDuration(newEvent.getDuration());
            event.setCanceled(newEvent.isCanceled());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUseFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack func;
        IMorphicTool tool = (IMorphicTool)event.getItem().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null && !(func = tool.getFunctionalStack()).func_190926_b()) {
            LivingEntityUseItemEvent.Finish newEvent = new LivingEntityUseItemEvent.Finish(event.getEntityLiving(), func, event.getDuration(), ((IMorphicTool)event.getResultStack().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).getFunctionalStack());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
            event.setDuration(newEvent.getDuration());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        boolean toMorphic;
        IMorphicTool from = (IMorphicTool)event.getFrom().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        IMorphicTool to = (IMorphicTool)event.getTo().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        boolean fromMorphic = from != null && !from.getFunctionalStack().func_190926_b();
        boolean bl = toMorphic = to != null && !to.getFunctionalStack().func_190926_b();
        if (fromMorphic || toMorphic) {
            LivingEquipmentChangeEvent newEvent = new LivingEquipmentChangeEvent(event.getEntityLiving(), event.getSlot(), fromMorphic ? from.getFunctionalStack() : event.getFrom(), toMorphic ? to.getFunctionalStack() : event.getFrom());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
        }
    }

    private static void setStackSilently(EntityLivingBase entity, EnumHand hand, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (hand == EnumHand.MAIN_HAND) {
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
            } else if (hand == EnumHand.OFF_HAND) {
                player.field_71071_by.field_184439_c.set(0, (Object)stack);
            }
        } else {
            entity.func_184611_a(hand, stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        IMorphicTool tool = (IMorphicTool)event.getItemStack().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null) {
            ItemStack old = event.getItemStack();
            if (!tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), tool.getFunctionalStack());
                PlayerInteractEvent.EntityInteract newEvent = new PlayerInteractEvent.EntityInteract(event.getEntityPlayer(), event.getHand(), event.getTarget());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), old);
                event.setCanceled(newEvent.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntitySpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        IMorphicTool tool = (IMorphicTool)event.getItemStack().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null) {
            ItemStack old = event.getItemStack();
            if (!tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), tool.getFunctionalStack());
                PlayerInteractEvent.EntityInteractSpecific newEvent = new PlayerInteractEvent.EntityInteractSpecific(event.getEntityPlayer(), event.getHand(), event.getTarget(), event.getLocalPos());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), old);
                event.setCanceled(newEvent.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        IMorphicTool tool = (IMorphicTool)event.getItemStack().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null) {
            ItemStack old = event.getItemStack();
            if (!tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), tool.getFunctionalStack());
                PlayerInteractEvent.LeftClickBlock newEvent = new PlayerInteractEvent.LeftClickBlock(event.getEntityPlayer(), event.getPos(), event.getFace(), event.getHitVec());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), old);
                event.setUseBlock(newEvent.getUseBlock());
                event.setUseItem(newEvent.getUseItem());
                event.setCanceled(newEvent.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        IMorphicTool tool = (IMorphicTool)event.getItemStack().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null) {
            ItemStack old = event.getItemStack();
            if (!tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), tool.getFunctionalStack());
                PlayerInteractEvent.RightClickBlock newEvent = new PlayerInteractEvent.RightClickBlock(event.getEntityPlayer(), event.getHand(), event.getPos(), event.getFace(), event.getHitVec());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), old);
                event.setUseBlock(newEvent.getUseBlock());
                event.setUseItem(newEvent.getUseItem());
                event.setCanceled(newEvent.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractRightClickItem(PlayerInteractEvent.RightClickItem event) {
        IMorphicTool tool = (IMorphicTool)event.getItemStack().getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        if (tool != null) {
            ItemStack old = event.getItemStack();
            if (!tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), tool.getFunctionalStack());
                PlayerInteractEvent.RightClickItem newEvent = new PlayerInteractEvent.RightClickItem(event.getEntityPlayer(), event.getHand());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getEntityPlayer(), event.getHand(), old);
                event.setCanceled(newEvent.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184600_cs() != null) {
            EnumHand hand = event.getPlayer().func_184600_cs();
            ItemStack stack = event.getPlayer().func_184586_b(hand);
            IMorphicTool tool = (IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
            if (tool != null && !tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getPlayer(), hand, tool.getFunctionalStack());
                BlockEvent.BreakEvent newEvent = new BlockEvent.BreakEvent(event.getWorld(), event.getPos(), event.getState(), event.getPlayer());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getPlayer(), hand, stack);
                event.setCanceled(newEvent.isCanceled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && event.getHarvester().func_184600_cs() != null) {
            EnumHand hand = event.getHarvester().func_184600_cs();
            ItemStack stack = event.getHarvester().func_184586_b(hand);
            IMorphicTool tool = (IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
            if (tool != null && !tool.getFunctionalStack().func_190926_b()) {
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getHarvester(), hand, tool.getFunctionalStack());
                BlockEvent.HarvestDropsEvent newEvent = new BlockEvent.HarvestDropsEvent(event.getWorld(), event.getPos(), event.getState(), event.getFortuneLevel(), event.getDropChance(), event.getDrops(), event.getHarvester(), event.isSilkTouching());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                MorphicEventHandler.setStackSilently((EntityLivingBase)event.getHarvester(), hand, stack);
                event.setDropChance(newEvent.getDropChance());
            }
        }
    }
}

