/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.entities.monster.EntitySpellBat;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusStorage;
import thecodex6824.thaumicaugmentation.api.ward.entity.CapabilityWardOwnerProvider;
import thecodex6824.thaumicaugmentation.api.ward.entity.WardOwnerProviderOwnable;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocasterBase;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;
import thecodex6824.thaumicaugmentation.init.GUIHandler;

public class EntityAutocaster
extends EntityAutocasterBase
implements IEntityOwnable {
    protected static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(EntityAutocaster.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Byte> TARGETS = EntityDataManager.func_187226_a(EntityAutocaster.class, (DataSerializer)DataSerializers.field_187191_a);
    protected WeakReference<Entity> ownerRef = new WeakReference<Object>(null);
    protected EntityAutocasterBase.EntityAINearestValidTarget targeting;
    protected WardOwnerProviderOwnable<EntityAutocaster> wardOwner;
    protected ImpetusStorage impetus;

    protected boolean teamCheck(EntityLivingBase target) {
        boolean onSameTeam;
        Team myTeam = this.func_96124_cp();
        Team theirTeam = target.func_96124_cp();
        boolean bl = onSameTeam = myTeam != null && myTeam == theirTeam;
        if (onSameTeam && !this.getTargetFriendly()) {
            return false;
        }
        if (myTeam != null && !onSameTeam && this.getTargetFriendly()) {
            return false;
        }
        if (target.equals((Object)this.func_70902_q()) && !this.getTargetFriendly()) {
            return false;
        }
        if (target instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)target;
            if (ownable.func_70902_q() != null && ownable.func_70902_q().equals((Object)this.func_70902_q()) && !this.getTargetFriendly()) {
                return false;
            }
            if (ownable.func_70902_q() != null && !onSameTeam && !ownable.func_70902_q().equals((Object)this.func_70902_q()) && this.getTargetFriendly()) {
                return false;
            }
        } else if (target instanceof EntitySpellBat) {
            EntitySpellBat bat = (EntitySpellBat)target;
            if (bat.getOwner() != null && (bat.getOwner().equals((Object)this) || bat.getOwner().equals((Object)this.func_70902_q()))) {
                return false;
            }
            if (bat.getOwner() != null && myTeam != null && bat.getOwner().func_96124_cp() == myTeam) {
                return false;
            }
        }
        return true;
    }

    protected boolean animalTargetSelector(EntityLivingBase entity) {
        if (entity instanceof IAnimals) {
            return this.teamCheck(entity);
        }
        return false;
    }

    protected boolean mobTargetSelector(EntityLivingBase entity) {
        if (entity instanceof IMob) {
            return this.teamCheck(entity);
        }
        return false;
    }

    protected boolean playerTargetSelector(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && ThaumicAugmentation.proxy.isPvPEnabled()) {
            return this.teamCheck(entity);
        }
        return false;
    }

    public EntityAutocaster(World world) {
        super(world);
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        this.impetus = new ImpetusStorage(50L, 25L);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(TARGETS, (Object)2);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAutocasterBase.EntityAIWatchTarget(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 12.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targeting = new EntityAutocasterBase.EntityAINearestValidTarget(this, true, 2);
        this.targeting.addTargetSelector(this::mobTargetSelector);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.targeting);
    }

    public boolean getTargetAnimals() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 0);
    }

    public void setTargetAnimals(boolean target) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 0, target)));
        if (this.targeting != null) {
            if (target) {
                this.targeting.addTargetSelector(this::animalTargetSelector);
            } else {
                this.targeting.removeTargetSelector(this::animalTargetSelector);
            }
            this.targeting.func_75251_c();
        }
    }

    public boolean getTargetMobs() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 1);
    }

    public void setTargetMobs(boolean target) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 1, target)));
        if (this.targeting != null) {
            if (target) {
                this.targeting.addTargetSelector(this::mobTargetSelector);
            } else {
                this.targeting.removeTargetSelector(this::mobTargetSelector);
            }
            this.targeting.func_75251_c();
        }
    }

    public boolean getTargetPlayers() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 2);
    }

    public void setTargetPlayers(boolean target) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 2, target)));
        if (this.targeting != null) {
            if (target) {
                this.targeting.addTargetSelector(this::playerTargetSelector);
            } else {
                this.targeting.removeTargetSelector(this::playerTargetSelector);
            }
            this.targeting.func_75251_c();
        }
    }

    public boolean getTargetFriendly() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 3);
    }

    public void setTargetFriendly(boolean target) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 3, target)));
        if (this.targeting != null) {
            this.targeting.func_75251_c();
        }
    }

    public boolean getRedstoneControl() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 4);
    }

    public void setRedstoneControl(boolean redstone) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 4, redstone)));
        if (this.targeting != null) {
            this.targeting.func_75251_c();
        }
    }

    protected void func_70626_be() {
        if (this.isDisabled()) {
            this.targeting.func_75251_c();
            BlockPos base = this.func_180425_c().func_177977_b();
            this.field_70749_g.func_75650_a((double)base.func_177958_n() + 0.5, (double)base.func_177956_o() + 0.5, (double)base.func_177952_p() + 0.5, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            this.field_70749_g.func_75649_a();
        } else {
            super.func_70626_be();
        }
    }

    @Nullable
    public Entity func_70902_q() {
        if ((this.ownerRef.get() == null || ((Entity)this.ownerRef.get()).field_70128_L) && ((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).isPresent()) {
            this.ownerRef.clear();
            List entities = this.field_70170_p.func_175644_a(Entity.class, entity -> entity != null && entity.getPersistentID().equals(((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get()));
            if (!entities.isEmpty()) {
                this.ownerRef = new WeakReference(entities.get(0));
            } else {
                List players = !this.field_70170_p.field_72995_K ? FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v() : this.field_70170_p.func_175661_b(EntityPlayer.class, Predicates.alwaysTrue());
                for (EntityPlayer p : players) {
                    if (!p.func_110124_au().equals(((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get())) continue;
                    this.ownerRef = new WeakReference<EntityPlayer>(p);
                    break;
                }
            }
        }
        return (Entity)this.ownerRef.get();
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).orNull();
    }

    public void setOwner(Entity newOwner) {
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.of((Object)newOwner.getPersistentID()));
        this.ownerRef = new WeakReference<Entity>(newOwner);
    }

    public boolean func_184191_r(Entity other) {
        Entity owner = this.func_70902_q();
        if (other.equals((Object)owner)) {
            return true;
        }
        if (owner != null && other.func_184191_r(this.func_70902_q())) {
            return true;
        }
        return super.func_184191_r(other);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.func_110143_aJ() > 0.0f) {
            if (player.equals((Object)this.func_70902_q())) {
                if (player.func_70093_af()) {
                    this.func_184185_a(SoundsTC.zap, 1.0f, 1.0f);
                    this.dropFocus();
                    this.func_70099_a(new ItemStack(TAItems.AUTOCASTER_PLACER), 0.5f);
                    this.func_70106_y();
                    player.func_184609_a(hand);
                    return true;
                }
                player.openGui((Object)ThaumicAugmentation.instance, GUIHandler.TAInventory.AUTOCASTER.getID(), this.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
            player.func_146105_b(new TextComponentTranslation("tc.notowned", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE).func_150217_b(Boolean.valueOf(true))), true);
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected boolean isDisabled() {
        if (BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 4)) {
            if (this.field_70170_p.func_175640_z(this.func_180425_c())) {
                return true;
            }
            IBlockState rail = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            if (rail.func_177230_c() == BlocksTC.activatorRail && ((Boolean)rail.func_177229_b((IProperty)BlockRailPowered.field_176569_M)).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return TALootTables.AUTOCASTER;
    }

    @Override
    protected void dropItemFromPlacement() {
        this.dropFocus();
        this.func_70099_a(new ItemStack(TAItems.AUTOCASTER_PLACER), 0.5f);
    }

    @Override
    protected int getHealRate() {
        return 100;
    }

    protected void dropFocus() {
        if (this.func_184614_ca() != null && !this.func_184614_ca().func_190926_b()) {
            this.func_70099_a(this.func_184614_ca(), 0.5f);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropFocus();
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(TAItems.AUTOCASTER_PLACER);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("energy", (NBTBase)this.impetus.serializeNBT());
        if (((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).isPresent()) {
            compound.func_186854_a("owner", (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get());
        }
        compound.func_74768_a("dir", ((EnumFacing)this.field_70180_af.func_187225_a(FACING)).func_176745_a());
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74774_a("targets", ((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.impetus.deserializeNBT(compound.func_74775_l("energy"));
        if (compound.func_186855_b("owner")) {
            this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.of((Object)compound.func_186857_a("owner")));
        }
        this.field_70180_af.func_187227_b(FACING, (Object)EnumFacing.func_82600_a((int)compound.func_74762_e("dir")));
        this.cooldown = compound.func_74762_e("cooldown");
        this.field_70180_af.func_187227_b(TARGETS, (Object)compound.func_74771_c("targets"));
        this.setTargetAnimals(this.getTargetAnimals());
        this.setTargetMobs(this.getTargetMobs());
        this.setTargetPlayers(this.getTargetPlayers());
        this.setTargetFriendly(this.getTargetFriendly());
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(TARGETS)).byteValue(), 4) && this.field_70170_p.func_175640_z(this.func_180425_c().func_177972_a(((EnumFacing)this.field_70180_af.func_187225_a(FACING)).func_176734_d()))) {
            return false;
        }
        if (this.getTargetAnimals() && IAnimals.class.isAssignableFrom(cls) && !IMob.class.isAssignableFrom(cls)) {
            return true;
        }
        if (this.getTargetMobs() && IMob.class.isAssignableFrom(cls)) {
            return true;
        }
        return this.getTargetPlayers() && EntityPlayer.class.isAssignableFrom(cls);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityWardOwnerProvider.WARD_OWNER || capability == CapabilityImpetusStorage.IMPETUS_STORAGE ? true : super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityWardOwnerProvider.WARD_OWNER) {
            if (this.wardOwner == null) {
                this.wardOwner = new WardOwnerProviderOwnable<EntityAutocaster>(this);
            }
            return (T)CapabilityWardOwnerProvider.WARD_OWNER.cast(this.wardOwner);
        }
        if (capability == CapabilityImpetusStorage.IMPETUS_STORAGE) {
            return (T)CapabilityImpetusStorage.IMPETUS_STORAGE.cast((Object)this.impetus);
        }
        return (T)super.getCapability(capability, facing);
    }
}

