/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.IStarfieldGlassType;
import thecodex6824.thaumicaugmentation.common.block.BlockFortifiedGlass;
import thecodex6824.thaumicaugmentation.common.block.trait.IRenderableSides;
import thecodex6824.thaumicaugmentation.common.item.block.ItemBlockStarfieldGlass;
import thecodex6824.thaumicaugmentation.common.tile.TileStarfieldGlass;

public class BlockStarfieldGlass
extends BlockFortifiedGlass
implements IStarfieldGlassType {
    public BlockStarfieldGlass() {
        this.func_180632_j(this.func_176223_P().func_177226_a(IStarfieldGlassType.GLASS_TYPE, (Comparable)((Object)IStarfieldGlassType.GlassType.GLASS_RIFT)));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockStarfieldGlass();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{IStarfieldGlassType.GLASS_TYPE}).add(new IUnlistedProperty[]{IRenderableSides.SIDES}).build();
    }

    public int func_176201_c(IBlockState state) {
        return ((IStarfieldGlassType.GlassType)((Object)state.func_177229_b(IStarfieldGlassType.GLASS_TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(IStarfieldGlassType.GLASS_TYPE, (Comparable)((Object)IStarfieldGlassType.GlassType.fromMeta(meta)));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState ext = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        IBlockState clean = ext.getClean();
        ImmutableList.Builder faces = ImmutableList.builder();
        BlockPos.MutableBlockPos work = new BlockPos.MutableBlockPos();
        block0: for (EnumFacing face : EnumFacing.field_82609_l) {
            if (state.func_185894_c(world, pos, face)) {
                faces.add((Object)face);
                continue;
            }
            for (EnumFacing otherFace : EnumFacing.field_82609_l) {
                if (otherFace == face.func_176734_d()) continue;
                work.func_189533_g((Vec3i)pos.func_177972_a(otherFace));
                IBlockState check = world.func_180495_p((BlockPos)work);
                if (check != clean || !check.func_185894_c(world, (BlockPos)work, face)) continue;
                faces.add((Object)face);
                continue block0;
            }
        }
        return ext.withProperty(IRenderableSides.SIDES, (Object)faces.build());
    }

    public int func_180651_a(IBlockState state) {
        return ((IStarfieldGlassType.GlassType)((Object)state.func_177229_b(IStarfieldGlassType.GLASS_TYPE))).getMeta();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileStarfieldGlass();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            for (IStarfieldGlassType.GlassType type : IStarfieldGlassType.GlassType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
    }
}

