/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.sound;

import com.google.common.math.DoubleMath;
import java.util.function.Function;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;

public class MovingSoundRecord
extends MovingSound {
    protected Function<Vec3d, Vec3d> tickFunc;
    protected int fadeIn;
    protected float fadeOut;
    protected int ticks;
    protected boolean inFadeOut;

    public MovingSoundRecord(SoundEvent sound, SoundCategory category, Function<Vec3d, Vec3d> tick) {
        this(sound, category, tick, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public MovingSoundRecord(SoundEvent sound, SoundCategory category, Function<Vec3d, Vec3d> tick, float x, float y, float z) {
        this(sound, category, tick, x, y, z, 1.0f, 1.0f);
    }

    public MovingSoundRecord(SoundEvent sound, SoundCategory category, Function<Vec3d, Vec3d> tick, float x, float y, float z, float soundVolume, float soundPitch) {
        this(sound, category, tick, x, y, z, soundVolume, soundPitch, false, 0);
    }

    public MovingSoundRecord(SoundEvent sound, SoundCategory category, Function<Vec3d, Vec3d> tick, float x, float y, float z, float soundVolume, float soundPitch, boolean repeatSound, int repeatDelayTicks) {
        super(sound, category);
        this.tickFunc = tick;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.field_147659_g = repeatSound;
        this.field_147665_h = repeatDelayTicks;
        this.field_147662_b = soundVolume;
        this.field_147663_c = soundPitch;
        this.setPos(x, y, z);
        this.fadeIn = -1;
        this.fadeOut = -1.0f;
    }

    public void setPos(float x, float y, float z) {
        this.field_147660_d = x;
        this.field_147661_e = y;
        this.field_147658_f = z;
    }

    public void setAttenuationType(ISound.AttenuationType newType) {
        this.field_147666_i = newType;
    }

    public void setFadeIn(int fade) {
        this.fadeIn = fade;
    }

    public void setFadeOut(int fade) {
        this.fadeOut = this.field_147662_b / (float)fade;
    }

    public void stop() {
        this.field_147668_j = true;
    }

    public void func_73660_a() {
        Vec3d pos;
        Vec3d orig = new Vec3d((double)this.field_147660_d, (double)this.field_147661_e, (double)this.field_147658_f);
        Vec3d vec3d = pos = this.inFadeOut ? orig : this.tickFunc.apply(orig);
        if (pos == null) {
            if (this.fadeOut > 0.0f) {
                this.inFadeOut = true;
            } else {
                this.field_147668_j = true;
            }
        } else {
            this.setPos((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
            if (this.ticks <= this.fadeIn) {
                this.field_147662_b = (float)this.ticks / (float)this.fadeIn;
            } else if (this.inFadeOut) {
                this.field_147662_b -= this.fadeOut;
                if (DoubleMath.fuzzyEquals((double)this.field_147662_b, (double)0.0, (double)0.001)) {
                    this.field_147668_j = true;
                }
            }
        }
        ++this.ticks;
    }
}

