/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.renderer.entity;

import com.sasmaster.glelwjgl.java.CoreGLE;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.utils.EntityUtils;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TATextures;
import thecodex6824.thaumicaugmentation.client.shader.TAShaderManager;
import thecodex6824.thaumicaugmentation.client.shader.TAShaders;

public class RenderFluxRiftOptimized
extends Render<EntityFluxRift> {
    protected static final ResourceLocation TEXTURE = TATextures.RIFT;
    protected static final CoreGLE GLE = new CoreGLE();
    protected static double[][] POINT_BUFFER = new double[0][0];
    protected static float[][] COLOR_BUFFER = new float[0][0];
    protected static double[] RADIUS_BUFFER = new double[0];

    public RenderFluxRiftOptimized(RenderManager rm) {
        super(rm);
        this.field_76989_e = 0.0f;
    }

    public void doRender(EntityFluxRift rift, double x, double y, double z, float yaw, float pt) {
        if (Minecraft.func_71410_x().field_71424_I.field_76327_a) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("fluxrift");
        }
        if (rift.points.size() > 2) {
            Entity rv = Minecraft.func_71410_x().func_175606_aa();
            if (rv == null) {
                rv = Minecraft.func_71410_x().field_71439_g;
            }
            boolean goggles = EntityUtils.hasGoggles((Entity)rv);
            GlStateManager.func_179094_E();
            this.func_110776_a(TEXTURE);
            TAShaderManager.enableShader(TAShaders.FLUX_RIFT, TAShaders.SHADER_CALLBACK_GENERIC_SPHERE);
            float amp = 1.0f;
            float stab = MathHelper.func_76131_a((float)(1.0f - rift.getRiftStability() / 50.0f), (float)0.0f, (float)1.5f);
            GlStateManager.func_179147_l();
            for (int layer = 0; layer < 4; ++layer) {
                if (layer < 3) {
                    GlStateManager.func_179132_a((boolean)false);
                    if (layer == 0 && goggles) {
                        GlStateManager.func_179097_i();
                    }
                }
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)(layer != 3 ? GlStateManager.DestFactor.ONE : GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));
                GlStateManager.func_179094_E();
                if (rift.points.size() > POINT_BUFFER.length) {
                    POINT_BUFFER = new double[rift.points.size()][3];
                    for (float[] arr : COLOR_BUFFER = new float[rift.points.size()][4]) {
                        Arrays.fill(arr, 1.0f);
                    }
                    RADIUS_BUFFER = new double[rift.points.size()];
                }
                for (int i = 0; i < rift.points.size(); ++i) {
                    float var = (float)rift.field_70173_aa + pt;
                    if (i > rift.points.size() / 2) {
                        var -= (float)(i * 10);
                    } else if (i < rift.points.size() / 2) {
                        var += (float)(i * 10);
                    }
                    RenderFluxRiftOptimized.POINT_BUFFER[i][0] = ((Vec3d)rift.points.get((int)i)).field_72450_a + x + (double)MathHelper.func_76126_a((float)(var / 50.0f * amp)) * (double)0.1f * (double)stab;
                    RenderFluxRiftOptimized.POINT_BUFFER[i][1] = ((Vec3d)rift.points.get((int)i)).field_72448_b + y + (double)MathHelper.func_76126_a((float)(var / 60.0f * amp)) * (double)0.1f * (double)stab;
                    RenderFluxRiftOptimized.POINT_BUFFER[i][2] = ((Vec3d)rift.points.get((int)i)).field_72449_c + z + (double)MathHelper.func_76126_a((float)(var / 70.0f * amp)) * (double)0.1f * (double)stab;
                    double width = 1.0 - (double)MathHelper.func_76126_a((float)(var / 8.0f * amp)) * (double)0.1f * (double)stab;
                    RenderFluxRiftOptimized.RADIUS_BUFFER[i] = (double)((Float)rift.pointsWidth.get(i)).floatValue() * width * (double)(layer != 3 ? 1.25f + 0.5f * (float)layer : 1.0f);
                }
                GLE.glePolyCone(rift.points.size(), POINT_BUFFER, COLOR_BUFFER, RADIUS_BUFFER, 1.0f, 0.0f);
                GlStateManager.func_179121_F();
                if (layer >= 3) continue;
                GlStateManager.func_179132_a((boolean)true);
                if (layer != 0 || !goggles) continue;
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179084_k();
            TAShaderManager.disableShader();
            GlStateManager.func_179121_F();
        }
        if (Minecraft.func_71410_x().field_71424_I.field_76327_a) {
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityFluxRift entity) {
        return null;
    }

    static {
        GLE.set_POLYCYL_TESS(6);
        GLE.gleSetJoinStyle(2);
    }
}

