/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.world;

import java.util.HashMap;
import net.minecraft.world.biome.Biome;

public final class BiomeMonitorColors {
    private static final MonitorColors NULL_ENTRY = new MonitorColors(-1, -1, -1);
    private static HashMap<String, MonitorColors> overrides = new HashMap();

    private BiomeMonitorColors() {
    }

    public static void registerMonitorColorOverride(Biome biome, int grassColor, int plantColor, int waterColor) {
        overrides.put(biome.getRegistryName().toString(), new MonitorColors(grassColor, plantColor, waterColor));
    }

    public static MonitorColors getMonitorColors(Biome biome) {
        return overrides.getOrDefault(biome.getRegistryName().toString(), NULL_ENTRY);
    }

    public static void init() {
    }

    public static class MonitorColors {
        private int grass;
        private int plants;
        private int water;

        public MonitorColors(int g, int p, int w) {
            this.grass = g;
            this.plants = p;
            this.water = w;
        }

        public int getGrassColor() {
            return this.grass;
        }

        public int getPlantColor() {
            return this.plants;
        }

        public int getWaterColor() {
            return this.water;
        }
    }
}

